/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.drop;

import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.view.drop.DropViewDesc;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class DropViewOperation
extends DDLOperation<DropViewDesc> {
    public DropViewOperation(DDLOperationContext context, DropViewDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Table table = this.getTable();
        if (table == null) {
            return 0;
        }
        if (!table.isView()) {
            if (((DropViewDesc)this.desc).isIfExists()) {
                return 0;
            }
            if (table.isMaterializedView()) {
                throw new HiveException("Cannot drop a materialized view with DROP VIEW");
            }
            throw new HiveException("Cannot drop a base table with DROP VIEW");
        }
        this.context.getDb().dropTable(((DropViewDesc)this.desc).getTableName(), false);
        DDLUtils.addIfAbsentByName(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK), this.context);
        return 0;
    }

    private Table getTable() throws HiveException {
        try {
            return this.context.getDb().getTable(((DropViewDesc)this.desc).getTableName());
        }
        catch (InvalidTableException e) {
            return null;
        }
    }
}

