/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.properties;

import java.util.Set;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AlterTableUnsetPropertiesDesc;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterTableUnsetPropertiesOperation
extends AbstractAlterTableOperation<AlterTableUnsetPropertiesDesc> {
    public AlterTableUnsetPropertiesOperation(DDLOperationContext context, AlterTableUnsetPropertiesDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        if ("USER".equals(this.environmentContext.getProperties().get("STATS_GENERATED"))) {
            this.environmentContext.getProperties().remove("DO_NOT_UPDATE_STATS");
        }
        if (partition == null) {
            Set<String> removedSet = ((AlterTableUnsetPropertiesDesc)this.desc).getProps().keySet();
            boolean isFromMmTable = AcidUtils.isInsertOnlyTable(table.getParameters());
            boolean isRemoved = AcidUtils.isRemovedInsertOnlyTable(removedSet);
            if (isFromMmTable && isRemoved) {
                throw new HiveException("Cannot convert an ACID table to non-ACID");
            }
            if (removedSet.contains("EXTERNAL") && table.getTableType() == TableType.EXTERNAL_TABLE) {
                table.setTableType(TableType.MANAGED_TABLE);
            }
        }
        for (String key : ((AlterTableUnsetPropertiesDesc)this.desc).getProps().keySet()) {
            if (partition != null) {
                partition.getTPartition().getParameters().remove(key);
                continue;
            }
            table.getTTable().getParameters().remove(key);
        }
    }
}

