/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.status;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Table Status", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowTableStatusDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEMA = "tab_name#string";
    private final String resFile;
    private final String dbName;
    private final String pattern;
    private final Map<String, String> partSpec;

    public ShowTableStatusDesc(Path resFile, String dbName, String pattern, Map<String, String> partSpec) {
        this.resFile = resFile.toString();
        this.dbName = dbName;
        this.pattern = pattern;
        this.partSpec = partSpec;
    }

    @Explain(displayName="pattern")
    public String getPattern() {
        return this.pattern;
    }

    public String getResFile() {
        return this.resFile;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFileString() {
        return this.getResFile();
    }

    @Explain(displayName="database", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbName() {
        return this.dbName;
    }

    @Explain(displayName="partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }
}

