/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.ObjectDictionary;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLDescWithTableProperties;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableOperation;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ValidationUtility;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.OutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Create Table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateTableDesc
extends DDLDescWithTableProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CreateTableDesc.class);
    TableName tableName;
    boolean isExternal;
    List<String> bucketCols;
    List<Order> sortCols;
    int numBuckets;
    String fieldDelim;
    String fieldEscape;
    String collItemDelim;
    String mapKeyDelim;
    String lineDelim;
    String nullFormat;
    List<String> skewedColNames;
    List<List<String>> skewedColValues;
    boolean isStoredAsSubDirectories = false;
    private boolean replaceMode = false;
    private ReplicationSpec replicationSpec = null;
    private boolean isCTAS = false;
    List<SQLPrimaryKey> primaryKeys;
    List<SQLForeignKey> foreignKeys;
    List<SQLUniqueConstraint> uniqueConstraints;
    List<SQLNotNullConstraint> notNullConstraints;
    List<SQLDefaultConstraint> defaultConstraints;
    List<SQLCheckConstraint> checkConstraints;
    private ColumnStatistics colStats;
    private Long replWriteId;
    private String likeFile = null;
    private String likeFileFormat = null;

    public CreateTableDesc() {
    }

    public CreateTableDesc(TableName tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints, ColumnStatistics colStats, long writeId) {
        this(tableName, isExternal, isTemporary, cols, partCols, bucketCols, sortCols, numBuckets, fieldDelim, fieldEscape, collItemDelim, mapKeyDelim, lineDelim, comment, inputFormat, outputFormat, location, serName, storageHandler, serdeProps, tblProps, ifNotExists, skewedColNames, skewedColValues, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
        this.colStats = colStats;
        this.replWriteId = writeId;
    }

    public CreateTableDesc(TableName tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<String> partColNames, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues, boolean isCTAS, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) {
        this(tableName, isExternal, isTemporary, cols, new ArrayList<FieldSchema>(), bucketCols, sortCols, numBuckets, fieldDelim, fieldEscape, collItemDelim, mapKeyDelim, lineDelim, comment, inputFormat, outputFormat, location, serName, storageHandler, serdeProps, tblProps, ifNotExists, skewedColNames, skewedColValues, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints, null, -1L);
        this.partColNames = partColNames;
        this.isCTAS = isCTAS;
    }

    public CreateTableDesc(TableName tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) {
        super(cols, partCols, comment, inputFormat, outputFormat, location, serName, storageHandler, serdeProps, tblProps, ifNotExists);
        this.tableName = tableName;
        this.isExternal = isExternal;
        this.isTemporary = isTemporary;
        this.bucketCols = new ArrayList<String>(bucketCols);
        this.sortCols = new ArrayList<Order>(sortCols);
        this.collItemDelim = collItemDelim;
        this.fieldDelim = fieldDelim;
        this.fieldEscape = fieldEscape;
        this.lineDelim = lineDelim;
        this.mapKeyDelim = mapKeyDelim;
        this.numBuckets = numBuckets;
        this.skewedColNames = CreateTableDesc.copyList(skewedColNames);
        this.skewedColValues = CreateTableDesc.copyList(skewedColValues);
        this.primaryKeys = CreateTableDesc.copyList(primaryKeys);
        this.foreignKeys = CreateTableDesc.copyList(foreignKeys);
        this.uniqueConstraints = CreateTableDesc.copyList(uniqueConstraints);
        this.notNullConstraints = CreateTableDesc.copyList(notNullConstraints);
        this.defaultConstraints = CreateTableDesc.copyList(defaultConstraints);
        this.checkConstraints = CreateTableDesc.copyList(checkConstraints);
    }

    private static <T> List<T> copyList(List<T> copy) {
        return copy == null ? null : new ArrayList<T>(copy);
    }

    public void setLikeFile(String likeFile) {
        this.likeFile = likeFile;
    }

    public void setLikeFileFormat(String likeFileFormat) {
        this.likeFileFormat = likeFileFormat;
    }

    public String getLikeFile() {
        return this.likeFile;
    }

    public String getLikeFileFormat() {
        return this.likeFileFormat;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    @Override
    public TableName getFullTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.tableName.getDb();
    }

    public void setTableName(TableName tableName) {
        this.tableName = tableName;
    }

    public List<SQLPrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(ArrayList<SQLPrimaryKey> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public List<SQLForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(ArrayList<SQLForeignKey> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public List<SQLUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public List<SQLNotNullConstraint> getNotNullConstraints() {
        return this.notNullConstraints;
    }

    public List<SQLDefaultConstraint> getDefaultConstraints() {
        return this.defaultConstraints;
    }

    public List<SQLCheckConstraint> getCheckConstraints() {
        return this.checkConstraints;
    }

    @Explain(displayName="bucket columns")
    public List<String> getBucketCols() {
        return this.bucketCols;
    }

    public void setBucketCols(ArrayList<String> bucketCols) {
        this.bucketCols = bucketCols;
    }

    @Explain(displayName="# buckets")
    public Integer getNumBucketsExplain() {
        if (this.numBuckets == -1) {
            return null;
        }
        return this.numBuckets;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    @Explain(displayName="field delimiter")
    public String getFieldDelim() {
        return this.fieldDelim;
    }

    public void setFieldDelim(String fieldDelim) {
        this.fieldDelim = fieldDelim;
    }

    @Explain(displayName="field escape")
    public String getFieldEscape() {
        return this.fieldEscape;
    }

    public void setFieldEscape(String fieldEscape) {
        this.fieldEscape = fieldEscape;
    }

    @Explain(displayName="collection delimiter")
    public String getCollItemDelim() {
        return this.collItemDelim;
    }

    public void setCollItemDelim(String collItemDelim) {
        this.collItemDelim = collItemDelim;
    }

    @Explain(displayName="map key delimiter")
    public String getMapKeyDelim() {
        return this.mapKeyDelim;
    }

    public void setMapKeyDelim(String mapKeyDelim) {
        this.mapKeyDelim = mapKeyDelim;
    }

    @Explain(displayName="line delimiter")
    public String getLineDelim() {
        return this.lineDelim;
    }

    public void setLineDelim(String lineDelim) {
        this.lineDelim = lineDelim;
    }

    @Explain(displayName="isExternal", displayOnlyOnTrue=true)
    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    @Explain(displayName="sort columns")
    public List<Order> getSortCols() {
        return this.sortCols;
    }

    public void setSortCols(ArrayList<Order> sortCols) {
        this.sortCols = sortCols;
    }

    public List<String> getSkewedColNames() {
        return this.skewedColNames;
    }

    public void setSkewedColNames(ArrayList<String> skewedColNames) {
        this.skewedColNames = skewedColNames;
    }

    public List<List<String>> getSkewedColValues() {
        return this.skewedColValues;
    }

    public void setSkewedColValues(ArrayList<List<String>> skewedColValues) {
        this.skewedColValues = skewedColValues;
    }

    public void validate(HiveConf conf) throws SemanticException {
        if (CollectionUtils.isEmpty(this.getCols())) {
            if (Table.hasMetastoreBasedSchema(conf, this.getSerde()) && StringUtils.isEmpty((CharSequence)this.getStorageHandler()) && this.getLikeFile() == null) {
                throw new SemanticException(ErrorMsg.INVALID_TBL_DDL_SERDE.getMsg());
            }
            return;
        }
        if (this.getStorageHandler() == null) {
            try {
                Class<?> origin = Class.forName(this.getOutputFormat(), true, Utilities.getSessionSpecifiedClassLoader());
                Class<? extends OutputFormat> replaced = HiveFileFormatUtils.getOutputFormatSubstitute(origin);
                if (!HiveOutputFormat.class.isAssignableFrom(replaced)) {
                    throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
                }
            }
            catch (ClassNotFoundException e) {
                throw new SemanticException(ErrorMsg.CLASSPATH_ERROR.getMsg(), (Throwable)e);
            }
        }
        List<String> colNames = ParseUtils.validateColumnNameUniqueness(this.getCols());
        CreateTableDesc.assertColumnsMatchSchema(colNames, this.getBucketCols());
        CreateTableDesc.assertColumnsMatchSchema(colNames, Iterables.transform(this.getSortCols(), Order::getCol));
        if (this.getPartCols() != null) {
            for (FieldSchema fs : this.getPartCols()) {
                String partCol = fs.getName();
                PrimitiveTypeInfo pti = null;
                try {
                    pti = TypeInfoFactory.getPrimitiveTypeInfo((String)fs.getType());
                }
                catch (Exception err) {
                    LOG.error("Failed to get type info", (Throwable)err);
                }
                if (null == pti) {
                    throw new SemanticException(ErrorMsg.PARTITION_COLUMN_NON_PRIMITIVE.getMsg() + " Found " + partCol + " of type: " + fs.getType());
                }
                for (String name : colNames) {
                    String colName = BaseSemanticAnalyzer.unescapeIdentifier(name);
                    if (!partCol.equalsIgnoreCase(colName)) continue;
                    throw new SemanticException(ErrorMsg.COLUMN_REPEATED_IN_PARTITIONING_COLS.getMsg());
                }
            }
        }
        ValidationUtility.validateSkewedInformation(colNames, this.getSkewedColNames(), this.getSkewedColValues());
    }

    private static void assertColumnsMatchSchema(List<String> schema, Iterable<String> colNames) throws SemanticException {
        if (colNames != null) {
            for (String column : colNames) {
                if (!schema.stream().noneMatch(column::equalsIgnoreCase)) continue;
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(" '" + column + "'"));
            }
        }
    }

    public boolean isStoredAsSubDirectories() {
        return this.isStoredAsSubDirectories;
    }

    public void setStoredAsSubDirectories(boolean isStoredAsSubDirectories) {
        this.isStoredAsSubDirectories = isStoredAsSubDirectories;
    }

    public String getNullFormat() {
        return this.nullFormat;
    }

    public void setNullFormat(String nullFormat) {
        this.nullFormat = nullFormat;
    }

    public void setTemporary(boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    public void setMaterialization(boolean isMaterialization) {
        this.isMaterialization = isMaterialization;
    }

    public void setReplaceMode(boolean replaceMode) {
        this.replaceMode = replaceMode;
    }

    public boolean getReplaceMode() {
        return this.replaceMode;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        if (this.replicationSpec == null) {
            this.replicationSpec = new ReplicationSpec();
        }
        return this.replicationSpec;
    }

    public boolean isCTAS() {
        return this.isCTAS;
    }

    public Table toTable(HiveConf conf) throws HiveException {
        String serDeClassName;
        Table tbl = new Table(this.tableName.getDb(), this.tableName.getTable());
        if (this.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(this.getTblProps());
        }
        if (this.getNumBuckets() != -1) {
            tbl.setNumBuckets(this.getNumBuckets());
        }
        if (this.getStorageHandler() != null) {
            tbl.setProperty("storage_handler", this.getStorageHandler());
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (this.getSerde() == null) {
            if (storageHandler == null) {
                serDeClassName = PlanUtils.getDefaultSerDe().getName();
                LOG.info("Default to " + serDeClassName + " for table " + String.valueOf(this.tableName));
            } else {
                serDeClassName = storageHandler.getSerDeClass().getName();
                LOG.info("Use StorageHandler-supplied " + serDeClassName + " for table " + String.valueOf(this.tableName));
            }
        } else {
            serDeClassName = this.getSerde();
            DDLUtils.validateSerDe(serDeClassName, conf);
        }
        tbl.setSerializationLib(serDeClassName);
        if (this.getFieldDelim() != null) {
            tbl.setSerdeParam("field.delim", this.getFieldDelim());
            tbl.setSerdeParam("serialization.format", this.getFieldDelim());
        }
        if (this.getFieldEscape() != null) {
            tbl.setSerdeParam("escape.delim", this.getFieldEscape());
        }
        if (this.getCollItemDelim() != null) {
            tbl.setSerdeParam("collection.delim", this.getCollItemDelim());
        }
        if (this.getMapKeyDelim() != null) {
            tbl.setSerdeParam("mapkey.delim", this.getMapKeyDelim());
        }
        if (this.getLineDelim() != null) {
            tbl.setSerdeParam("line.delim", this.getLineDelim());
        }
        if (this.getNullFormat() != null) {
            tbl.setSerdeParam("serialization.null.format", this.getNullFormat());
        }
        if (this.getSerdeProps() != null) {
            this.getSerdeProps().forEach(tbl::setSerdeParam);
        }
        DDLUtils.setColumnsAndStorePartitionTransformSpecOfTable(this.getCols(), this.getPartCols(), conf, tbl);
        if (this.getBucketCols() != null) {
            tbl.setBucketCols(this.getBucketCols());
        }
        if (this.getSortCols() != null) {
            tbl.setSortCols(this.getSortCols());
        }
        if (this.getComment() != null) {
            tbl.setProperty("comment", this.getComment());
        }
        if (this.getLocation() != null) {
            tbl.setDataLocation(new Path(this.getLocation()));
        }
        if (this.getSkewedColNames() != null) {
            tbl.setSkewedColNames(this.getSkewedColNames());
        }
        if (this.getSkewedColValues() != null) {
            tbl.setSkewedColValues(this.getSkewedColValues());
        }
        tbl.getTTable().setTemporary(this.isTemporary());
        tbl.setStoredAsSubDirectories(this.isStoredAsSubDirectories());
        tbl.setInputFormatClass(this.getInputFormat());
        tbl.setOutputFormatClass(this.getOutputFormat());
        if (this.getInputFormat() != null && !this.getInputFormat().isEmpty()) {
            tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
        }
        if (this.getOutputFormat() != null && !this.getOutputFormat().isEmpty()) {
            tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        }
        if (CreateTableOperation.doesTableNeedLocation(tbl)) {
            CreateTableOperation.makeLocationQualified(tbl, conf);
        }
        if (this.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
            tbl.setTableType(TableType.EXTERNAL_TABLE);
        }
        if (tbl.getBucketCols() != null && tbl.getSortCols() != null) {
            List<String> bucketCols = tbl.getBucketCols();
            List<Order> sortCols = tbl.getSortCols();
            if (!sortCols.isEmpty() && sortCols.size() >= bucketCols.size()) {
                boolean found = true;
                for (String bucketCol : bucketCols) {
                    boolean colFound = false;
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        if (!bucketCol.equals(sortCols.get(i).getCol())) continue;
                        colFound = true;
                        break;
                    }
                    if (colFound) continue;
                    found = false;
                    break;
                }
                if (found) {
                    tbl.setProperty("SORTBUCKETCOLSPREFIX", "TRUE");
                }
            }
        }
        if (this.colStats != null) {
            ColumnStatisticsDesc colStatsDesc = new ColumnStatisticsDesc(this.colStats.getStatsDesc());
            colStatsDesc.setCatName(tbl.getCatName());
            colStatsDesc.setDbName(tbl.getDbName());
            colStatsDesc.setTableName(tbl.getTableName());
            String engine = this.colStats.getEngine();
            if (engine == null) {
                engine = "hive";
            }
            ColumnStatistics columnStatistics = new ColumnStatistics(colStatsDesc, this.colStats.getStatsObj());
            columnStatistics.setEngine(engine);
            tbl.getTTable().setColStats(columnStatistics);
            if (this.replWriteId > 0L) {
                tbl.getTTable().setWriteId(this.replWriteId.longValue());
            }
        }
        if (this.replicationSpec == null || !this.replicationSpec.isInReplicationScope()) {
            StatsSetupConst.setStatsStateForCreateTable((Map)tbl.getTTable().getParameters(), null, (String)"false");
            if (!this.isCTAS && !tbl.isPartitioned() && !tbl.isTemporary() && conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER)) {
                ObjectDictionary dictionary = tbl.getTTable().isSetDictionary() ? tbl.getTTable().getDictionary() : new ObjectDictionary();
                ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
                String statsSetup = StatsSetupConst.ColumnStatsSetup.getStatsSetupAsString((boolean)true, (storageHandler != null && storageHandler.isTableMetaRefSupported() ? 1 : 0) != 0, (List)MetaStoreUtils.getColumnNames(tbl.getCols()));
                buffers.add(ByteBuffer.wrap(statsSetup.getBytes(StandardCharsets.UTF_8)));
                dictionary.putToValues("setStatsStateForCreateTable", buffers);
                tbl.getTTable().setDictionary(dictionary);
            }
        }
        if (this.ownerName != null) {
            tbl.setOwner(this.ownerName);
        }
        return tbl;
    }

    public Long getReplWriteId() {
        return this.replWriteId;
    }

    public void setReplWriteId(Long replWriteId) {
        this.replWriteId = replWriteId;
    }

    public void fromTable(org.apache.hadoop.hive.metastore.api.Table tTable) {
        if (tTable.getSd() != null && tTable.getSd().getLocation() != null) {
            this.setLocation(tTable.getSd().getLocation());
        }
        this.setExternal(TableType.EXTERNAL_TABLE.toString().equals(tTable.getTableType()));
        this.setTblProps(tTable.getParameters());
        this.tblProps.remove("create_table_as_external");
    }
}

