/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.process.show.compactions;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.process.show.compactions.ShowCompactionsDesc;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class ShowCompactionsOperation
extends DDLOperation<ShowCompactionsDesc> {
    public ShowCompactionsOperation(DDLOperationContext context, ShowCompactionsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        SessionState sessionState = SessionState.get();
        ShowCompactRequest request = this.getShowCompactioRequest((ShowCompactionsDesc)this.desc);
        ShowCompactResponse rsp = this.context.getDb().showCompactions(request);
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((ShowCompactionsDesc)this.desc).getResFile()), this.context);){
            if (!sessionState.isHiveServerQuery()) {
                this.writeHeader(os);
            }
            if (rsp.getCompacts() != null) {
                for (ShowCompactResponseElement e : rsp.getCompacts()) {
                    this.writeRow(os, e);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("show compactions: ", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private ShowCompactRequest getShowCompactioRequest(ShowCompactionsDesc desc) throws SemanticException {
        ShowCompactRequest request = new ShowCompactRequest();
        if (StringUtils.isBlank((CharSequence)desc.getDbName()) && StringUtils.isNotBlank((CharSequence)desc.getTbName())) {
            request.setDbName(SessionState.get().getCurrentDatabase());
        } else {
            request.setDbName(desc.getDbName());
        }
        if (StringUtils.isNotBlank((CharSequence)desc.getTbName())) {
            request.setTbName(desc.getTbName());
        }
        if (StringUtils.isNotBlank((CharSequence)desc.getPoolName())) {
            request.setPoolName(desc.getPoolName());
        }
        if (StringUtils.isNotBlank((CharSequence)desc.getCompactionType())) {
            request.setType(AcidUtils.compactionTypeStr2ThriftType(desc.getCompactionType()));
        }
        if (StringUtils.isNotBlank((CharSequence)desc.getCompactionStatus())) {
            request.setState(AcidUtils.compactionStateStr2Enum(desc.getCompactionStatus()).getSqlConst());
        }
        if (MapUtils.isNotEmpty(desc.getPartSpec())) {
            request.setPartName(AcidUtils.getPartitionName(desc.getPartSpec()));
        }
        if (desc.getCompactionId() > 0L) {
            request.setId(desc.getCompactionId());
        }
        if (desc.getLimit() > 0) {
            request.setLimit((long)desc.getLimit());
        }
        if (StringUtils.isNotBlank((CharSequence)desc.getOrderBy())) {
            request.setOrder(desc.getOrderBy());
        }
        return request;
    }

    private void writeHeader(DataOutputStream os) throws IOException {
        os.writeBytes("CompactionId");
        os.write(9);
        os.writeBytes("Database");
        os.write(9);
        os.writeBytes("Table");
        os.write(9);
        os.writeBytes("Partition");
        os.write(9);
        os.writeBytes("Type");
        os.write(9);
        os.writeBytes("State");
        os.write(9);
        os.writeBytes("Worker host");
        os.write(9);
        os.writeBytes("Worker");
        os.write(9);
        os.writeBytes("Enqueue Time");
        os.write(9);
        os.writeBytes("Start Time");
        os.write(9);
        os.writeBytes("Duration(ms)");
        os.write(9);
        os.writeBytes("HadoopJobId");
        os.write(9);
        os.writeBytes("Error message");
        os.write(9);
        os.writeBytes("Initiator host");
        os.write(9);
        os.writeBytes("Initiator");
        os.write(9);
        os.writeBytes("Pool name");
        os.write(9);
        os.writeBytes("TxnId");
        os.write(9);
        os.writeBytes("Next TxnId");
        os.write(9);
        os.writeBytes("Commit Time");
        os.write(9);
        os.writeBytes("Highest WriteId");
        os.write(10);
    }

    private void writeRow(DataOutputStream os, ShowCompactResponseElement e) throws IOException {
        os.writeBytes(Long.toString(e.getId()));
        os.write(9);
        os.writeBytes(e.getDbname());
        os.write(9);
        os.writeBytes(e.getTablename());
        os.write(9);
        String part = e.getPartitionname();
        os.writeBytes(part == null ? " --- " : part);
        os.write(9);
        os.writeBytes(e.getType().toString());
        os.write(9);
        os.writeBytes(e.getState());
        os.write(9);
        os.writeBytes(MetaStoreUtils.getHostFromId((String)e.getWorkerid()));
        os.write(9);
        os.writeBytes(MetaStoreUtils.getThreadIdFromId((String)e.getWorkerid()));
        os.write(9);
        os.writeBytes(e.isSetEnqueueTime() ? Long.toString(e.getEnqueueTime()) : " --- ");
        os.write(9);
        os.writeBytes(e.isSetStart() ? Long.toString(e.getStart()) : " --- ");
        os.write(9);
        os.writeBytes(e.isSetEndTime() ? Long.toString(e.getEndTime() - e.getStart()) : " --- ");
        os.write(9);
        os.writeBytes(e.isSetHadoopJobId() ? e.getHadoopJobId() : " --- ");
        os.write(9);
        String error = e.getErrorMessage();
        os.writeBytes(error == null ? " --- " : error);
        os.write(9);
        os.writeBytes(MetaStoreUtils.getHostFromId((String)e.getInitiatorId()));
        os.write(9);
        os.writeBytes(MetaStoreUtils.getThreadIdFromId((String)e.getInitiatorId()));
        os.write(9);
        os.writeBytes(e.isSetPoolName() ? e.getPoolName() : " --- ");
        os.write(9);
        os.writeBytes(e.isSetTxnId() ? Long.toString(e.getTxnId()) : " --- ");
        os.write(9);
        os.writeBytes(e.isSetNextTxnId() ? Long.toString(e.getNextTxnId()) : " --- ");
        os.write(9);
        os.writeBytes(e.isSetCommitTime() ? Long.toString(e.getCommitTime()) : " --- ");
        os.write(9);
        os.writeBytes(e.isSetHightestWriteId() ? Long.toString(e.getHightestWriteId()) : " --- ");
        os.write(10);
    }
}

