/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.teradata;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.ParseException;
import org.apache.commons.io.input.SwappedDataInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;

public class TeradataBinaryDataInputStream
extends SwappedDataInputStream {
    private static final int DATE_STRING_LENGTH = 8;

    public TeradataBinaryDataInputStream(InputStream input) {
        super(input);
    }

    public String readVarchar() throws IOException {
        int varcharLength = this.readUnsignedShort();
        byte[] varcharContent = new byte[varcharLength];
        int numOfBytesRead = this.in.read(varcharContent);
        if (varcharContent.length != 0 && numOfBytesRead != varcharLength) {
            throw new EOFException(String.format("Fail to read the varchar. Expect %d bytes, get %d bytes", varcharLength, numOfBytesRead));
        }
        return new String(varcharContent, "UTF8");
    }

    public Timestamp readTimestamp(Integer byteNum) throws IOException {
        byte[] timestampContent = new byte[byteNum.intValue()];
        int numOfBytesRead = this.in.read(timestampContent);
        if (timestampContent.length != 0 && numOfBytesRead != byteNum) {
            throw new EOFException(String.format("Fail to read the timestamp. Expect %d bytes, get %d bytes", byteNum, numOfBytesRead));
        }
        String timestampStr = new String(timestampContent, "UTF8");
        if (timestampStr.trim().length() == 0) {
            return null;
        }
        return Timestamp.valueOf((String)timestampStr);
    }

    public Date readDate() throws IOException, ParseException {
        int di = this.readInt();
        if (di == 0) {
            return null;
        }
        String dateString = String.valueOf(di + 19000000);
        if (dateString.length() < 8) {
            dateString = StringUtils.leftPad((String)dateString, (int)8, (char)'0');
        }
        Date date = new Date();
        date.setYear(Integer.parseInt(dateString.substring(0, 4)));
        date.setMonth(Integer.parseInt(dateString.substring(4, 6)));
        date.setDayOfMonth(Integer.parseInt(dateString.substring(6, 8)));
        return date;
    }

    public String readChar(int totalLength) throws IOException {
        byte[] charContent = new byte[totalLength];
        int numOfBytesRead = this.in.read(charContent);
        if (charContent.length != 0 && numOfBytesRead != totalLength) {
            throw new EOFException(String.format("Fail to read the varchar. Expect %d bytes, get %d bytes", totalLength, numOfBytesRead));
        }
        return new String(charContent, "UTF8");
    }

    public HiveDecimal readDecimal(int scale, int byteNum) throws IOException {
        byte[] decimalContent = new byte[byteNum];
        int numOfBytesRead = this.in.read(decimalContent);
        if (decimalContent.length != 0 && numOfBytesRead != byteNum) {
            throw new EOFException(String.format("Fail to read the decimal. Expect %d bytes, get %d bytes", byteNum, numOfBytesRead));
        }
        ArrayUtils.reverse((byte[])decimalContent);
        return HiveDecimal.create((BigInteger)new BigInteger(decimalContent), (int)scale);
    }

    public byte[] readVarbyte() throws IOException {
        int varbyteLength = this.readUnsignedShort();
        byte[] varbyteContent = new byte[varbyteLength];
        int numOfBytesRead = this.in.read(varbyteContent);
        if (varbyteContent.length != 0 && numOfBytesRead != varbyteLength) {
            throw new EOFException(String.format("Fail to read the varbyte. Expect %d bytes, get %d bytes", varbyteLength, numOfBytesRead));
        }
        return varbyteContent;
    }
}

