/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.adapter.druid.ComplexMetric;
import org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

public class DruidTable
extends AbstractTable
implements TranslatableTable {
    public static final String DEFAULT_TIMESTAMP_COLUMN = "__time";
    public static final Interval DEFAULT_INTERVAL = new Interval((ReadableInstant)new DateTime((Object)"1900-01-01", (Chronology)ISOChronology.getInstanceUTC()), (ReadableInstant)new DateTime((Object)"3000-01-01", (Chronology)ISOChronology.getInstanceUTC()));
    final DruidSchema schema;
    final String dataSource;
    final RelProtoDataType protoRowType;
    final ImmutableSet<String> metricFieldNames;
    final ImmutableList<Interval> intervals;
    final String timestampFieldName;
    final ImmutableMap<String, List<ComplexMetric>> complexMetrics;
    final ImmutableMap<String, SqlTypeName> allFields;

    public DruidTable(DruidSchema schema, String dataSource, RelProtoDataType protoRowType, Set<String> metricFieldNames, String timestampFieldName, List<Interval> intervals, Map<String, List<ComplexMetric>> complexMetrics, Map<String, SqlTypeName> allFields) {
        this.timestampFieldName = Objects.requireNonNull(timestampFieldName, "timestampFieldName");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
        this.protoRowType = protoRowType;
        this.metricFieldNames = ImmutableSet.copyOf(metricFieldNames);
        this.intervals = intervals != null ? ImmutableList.copyOf(intervals) : ImmutableList.of((Object)DEFAULT_INTERVAL);
        this.complexMetrics = complexMetrics == null ? ImmutableMap.of() : ImmutableMap.copyOf(complexMetrics);
        this.allFields = allFields == null ? ImmutableMap.of() : ImmutableMap.copyOf(allFields);
    }

    static Table create(DruidSchema druidSchema, String dataSourceName, List<Interval> intervals, Map<String, SqlTypeName> fieldMap, Set<String> metricNameSet, String timestampColumnName, DruidConnectionImpl connection, Map<String, List<ComplexMetric>> complexMetrics) {
        assert (connection != null);
        connection.metadata(dataSourceName, timestampColumnName, intervals, fieldMap, metricNameSet, complexMetrics);
        return DruidTable.create(druidSchema, dataSourceName, intervals, fieldMap, metricNameSet, timestampColumnName, complexMetrics);
    }

    static Table create(DruidSchema druidSchema, String dataSourceName, List<Interval> intervals, Map<String, SqlTypeName> fieldMap, Set<String> metricNameSet, String timestampColumnName, Map<String, List<ComplexMetric>> complexMetrics) {
        ImmutableMap fields = ImmutableMap.copyOf(fieldMap);
        return new DruidTable(druidSchema, dataSourceName, new MapRelProtoDataType((ImmutableMap<String, SqlTypeName>)fields, timestampColumnName), (Set<String>)ImmutableSet.copyOf(metricNameSet), timestampColumnName, intervals, complexMetrics, fieldMap);
    }

    public ComplexMetric resolveComplexMetric(String alias, AggregateCall call) {
        List<ComplexMetric> potentialMetrics = this.getComplexMetricsFrom(alias);
        for (ComplexMetric complexMetric : potentialMetrics) {
            if (!complexMetric.canBeUsed(call)) continue;
            return complexMetric;
        }
        return null;
    }

    public boolean isRolledUp(String column) {
        return this.complexMetrics.get((Object)column) != null && this.allFields.get((Object)column) != SqlTypeName.VARCHAR;
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, @Nullable SqlNode parent, @Nullable CalciteConnectionConfig config) {
        assert (this.isRolledUp(column));
        return (config != null && config.approximateDistinctCount() && DruidTable.isCountDistinct(call) || call.getOperator() == SqlStdOperatorTable.APPROX_COUNT_DISTINCT) && call.getOperandList().size() == 1 && DruidTable.isValidParentKind(parent);
    }

    private static boolean isValidParentKind(SqlNode node) {
        return node.getKind() == SqlKind.SELECT || node.getKind() == SqlKind.FILTER || DruidTable.isSupportedPostAggOperation(node.getKind());
    }

    private static boolean isCountDistinct(SqlCall call) {
        return call.getKind() == SqlKind.COUNT && call.getFunctionQuantifier() != null && call.getFunctionQuantifier().getValue() == SqlSelectKeyword.DISTINCT;
    }

    private static boolean isSupportedPostAggOperation(SqlKind kind) {
        return kind == SqlKind.PLUS || kind == SqlKind.MINUS || kind == SqlKind.DIVIDE || kind == SqlKind.TIMES;
    }

    public List<ComplexMetric> getComplexMetricsFrom(String alias) {
        return this.complexMetrics.containsKey((Object)alias) ? (List)this.complexMetrics.get((Object)alias) : new ArrayList<ComplexMetric>();
    }

    public boolean isComplexMetric(String alias) {
        return this.complexMetrics.get((Object)alias) != null;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        RelDataType rowType = (RelDataType)this.protoRowType.apply((Object)typeFactory);
        List fieldNames = rowType.getFieldNames();
        Preconditions.checkArgument((boolean)fieldNames.contains(this.timestampFieldName));
        Preconditions.checkArgument((boolean)fieldNames.containsAll((Collection<?>)this.metricFieldNames));
        return rowType;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        LogicalTableScan scan = LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)relOptTable, (List)ImmutableList.of());
        return DruidQuery.create(cluster, cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), relOptTable, this, (List<RelNode>)ImmutableList.of((Object)scan));
    }

    public boolean isMetric(String name) {
        return this.metricFieldNames.contains((Object)name);
    }

    private static class MapRelProtoDataType
    implements RelProtoDataType {
        private final ImmutableMap<String, SqlTypeName> fields;
        private final String timestampColumn;

        MapRelProtoDataType(ImmutableMap<String, SqlTypeName> fields) {
            this.fields = fields;
            this.timestampColumn = DruidTable.DEFAULT_TIMESTAMP_COLUMN;
        }

        MapRelProtoDataType(ImmutableMap<String, SqlTypeName> fields, String timestampColumn) {
            this.fields = fields;
            this.timestampColumn = timestampColumn;
        }

        public RelDataType apply(RelDataTypeFactory typeFactory) {
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (Map.Entry field : this.fields.entrySet()) {
                String key = (String)field.getKey();
                builder.add(key, (SqlTypeName)field.getValue()).nullable(!this.timestampColumn.equals(key));
            }
            return builder.build();
        }
    }
}

