/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.ReplLastIdInfo;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.CommitCompactionEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.entities.OperationType;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.entities.TxnWriteDetails;
import org.apache.hadoop.hive.metastore.txn.jdbc.InClauseBatchCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.RollbackException;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionContext;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.DeleteReplTxnMapEntryCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.InsertCompletedTxnComponentsCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.RemoveTxnsFromMinHistoryLevelCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.RemoveWriteIdsFromMinHistoryCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AbortTxnsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AcquireTxnLockFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.FindTxnStateHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetCompactionInfoHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetHighWaterMarkHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetOpenTxnTypeAndLockHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetWriteIdsMappingForTxnIdsHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.TargetTxnIdListHandler;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CommitTxnFunction
implements TransactionalFunction<TxnType> {
    private static final Logger LOG = LoggerFactory.getLogger(CommitTxnFunction.class);
    private final CommitTxnRequest rqst;
    private final List<TransactionalMetaStoreEventListener> transactionalListeners;

    public CommitTxnFunction(CommitTxnRequest rqst, List<TransactionalMetaStoreEventListener> transactionalListeners) {
        this.rqst = rqst;
        this.transactionalListeners = transactionalListeners;
    }

    @Override
    public TxnType execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException, NoSuchTxnException, TxnAbortedException {
        TxnType txnType;
        int isUpdateDelete = 78;
        long txnid = this.rqst.getTxnid();
        long sourceTxnId = -1L;
        boolean isReplayedReplTxn = TxnType.REPL_CREATED.equals((Object)this.rqst.getTxn_type());
        boolean isHiveReplTxn = this.rqst.isSetReplPolicy() && TxnType.DEFAULT.equals((Object)this.rqst.getTxn_type());
        ArrayList<TxnWriteDetails> txnWriteDetails = new ArrayList();
        if (!isHiveReplTxn) {
            txnWriteDetails = jdbcResource.execute(new GetWriteIdsMappingForTxnIdsHandler(Set.of(Long.valueOf(this.rqst.getTxnid()))));
        }
        TransactionContext context = jdbcResource.getTransactionManager().getActiveTransaction();
        Long commitId = null;
        if (this.rqst.isSetReplLastIdInfo()) {
            this.updateReplId(jdbcResource, this.rqst.getReplLastIdInfo());
        }
        if (isReplayedReplTxn) {
            assert (this.rqst.isSetReplPolicy());
            sourceTxnId = this.rqst.getTxnid();
            List<Long> targetTxnIds = jdbcResource.execute(new TargetTxnIdListHandler(this.rqst.getReplPolicy(), Collections.singletonList(sourceTxnId)));
            if (targetTxnIds.isEmpty()) {
                LOG.info("Target txn id is missing for source txn id : {} and repl policy {}", (Object)sourceTxnId, (Object)this.rqst.getReplPolicy());
                throw new RollbackException((Object)null);
            }
            assert (targetTxnIds.size() == 1);
            txnid = targetTxnIds.getFirst();
        }
        if ((txnType = jdbcResource.execute(new GetOpenTxnTypeAndLockHandler(jdbcResource.getSqlGenerator(), txnid))) == null) {
            TxnStatus actualTxnStatus = jdbcResource.execute(new FindTxnStateHandler(txnid));
            if (actualTxnStatus == TxnStatus.COMMITTED) {
                if (isReplayedReplTxn) {
                    LOG.warn("Invalid state COMMITTED for transactions started using replication replay task");
                }
                LOG.info("Nth commitTxn({}) msg", (Object)JavaUtils.txnIdToString((long)txnid));
                return null;
            }
            TxnUtils.raiseTxnUnexpectedState(actualTxnStatus, txnid);
        }
        String conflictSQLSuffix = String.format("FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = :txnId AND \"TC_OPERATION_TYPE\" IN (%s, %s)\n", new Object[]{OperationType.UPDATE, OperationType.DELETE});
        long tempCommitId = TxnUtils.generateTemporaryId();
        if (txnType == TxnType.SOFT_DELETE || txnType == TxnType.COMPACTION) {
            if (!TxnHandler.ConfVars.useMinHistoryWriteId()) {
                new AcquireTxnLockFunction(false).execute(jdbcResource);
            }
            commitId = jdbcResource.execute(new GetHighWaterMarkHandler());
        } else if (txnType != TxnType.READ_ONLY && !isReplayedReplTxn) {
            String writeSetInsertSql = "INSERT INTO \"WRITE_SET\"\n  (\"WS_DATABASE\", \"WS_TABLE\", \"WS_PARTITION\", \"WS_TXNID\", \"WS_COMMIT_ID\", \"WS_OPERATION_TYPE\")\nSELECT DISTINCT\n  \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_TXNID\",\n  :commitId,\n  \"TC_OPERATION_TYPE\"\n";
            boolean isUpdateOrDelete = Boolean.TRUE.equals(jdbcResource.getJdbcTemplate().query(jdbcResource.getSqlGenerator().addLimitClause(1, "\"TC_OPERATION_TYPE\" " + conflictSQLSuffix), (SqlParameterSource)new MapSqlParameterSource().addValue("txnId", (Object)txnid), ResultSet::next));
            if (isUpdateOrDelete) {
                WriteSetInfo info;
                isUpdateDelete = 89;
                Object undoWriteSetForCurrentTxn = context.createSavepoint();
                jdbcResource.getJdbcTemplate().update(writeSetInsertSql + (String)(TxnHandler.ConfVars.useMinHistoryLevel() ? conflictSQLSuffix : "FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\"= :txnId" + (txnType != TxnType.REBALANCE_COMPACTION ? "" : " AND \"TC_OPERATION_TYPE\" <> :type")), (SqlParameterSource)new MapSqlParameterSource().addValue("txnId", (Object)txnid).addValue("type", (Object)OperationType.COMPACT.getSqlConst()).addValue("commitId", (Object)tempCommitId));
                new AcquireTxnLockFunction(false).execute(jdbcResource);
                commitId = jdbcResource.execute(new GetHighWaterMarkHandler());
                if (!this.rqst.isExclWriteEnabled() && (info = this.checkForWriteConflict(jdbcResource, txnid)) != null) {
                    String committedTxn = "[" + JavaUtils.txnIdToString((long)info.txnId) + "," + info.committedCommitId + "]";
                    StringBuilder resource = new StringBuilder(info.database).append("/").append(info.table);
                    if (info.partition != null) {
                        resource.append('/').append(info.partition);
                    }
                    String msg = "Aborting [" + JavaUtils.txnIdToString((long)txnid) + "," + commitId + "] due to a write conflict on " + String.valueOf(resource) + " committed by " + committedTxn + " " + info.currentOperationType + "/" + info.committedOperationType;
                    context.rollbackToSavepoint(undoWriteSetForCurrentTxn);
                    LOG.info(msg);
                    if (new AbortTxnsFunction(Collections.singletonList(txnid), false, false, isReplayedReplTxn, TxnErrorMsg.ABORT_WRITE_CONFLICT).execute(jdbcResource) != 1) {
                        throw new IllegalStateException(msg + " FAILED!");
                    }
                    throw new TxnAbortedException(msg);
                }
            } else if (!TxnHandler.ConfVars.useMinHistoryLevel()) {
                jdbcResource.getJdbcTemplate().update(writeSetInsertSql + "FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = :txnId", (SqlParameterSource)new MapSqlParameterSource().addValue("txnId", (Object)txnid).addValue("commitId", (Object)jdbcResource.execute(new GetHighWaterMarkHandler())));
            }
        }
        if (txnType != TxnType.READ_ONLY && !isReplayedReplTxn && !MetaStoreServerUtils.isCompactionTxn(txnType)) {
            this.moveTxnComponentsToCompleted(jdbcResource, txnid, (char)isUpdateDelete);
        } else if (isReplayedReplTxn) {
            if (this.rqst.isSetWriteEventInfos() && !this.rqst.getWriteEventInfos().isEmpty()) {
                jdbcResource.execute(new InsertCompletedTxnComponentsCommand(txnid, (char)isUpdateDelete, this.rqst.getWriteEventInfos()));
            }
            jdbcResource.execute(new DeleteReplTxnMapEntryCommand(sourceTxnId, this.rqst.getReplPolicy()));
        }
        this.updateWSCommitIdAndCleanUpMetadata(jdbcResource, txnid, txnType, commitId, tempCommitId);
        if (this.rqst.isSetKeyValue()) {
            this.updateKeyValueAssociatedWithTxn(jdbcResource, this.rqst);
        }
        if (!isHiveReplTxn) {
            this.createCommitNotificationEvent(jdbcResource, txnid, txnType, txnWriteDetails);
        }
        LOG.debug("Going to commit");
        if (MetastoreConf.getBoolVar((Configuration)jdbcResource.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) {
            Metrics.getOrCreateCounter("total_num_committed_transactions").inc();
        }
        return txnType;
    }

    private void updateReplId(MultiDataSourceJdbcResource jdbcResource, ReplLastIdInfo replLastIdInfo) throws MetaException {
        String lastReplId = Long.toString(replLastIdInfo.getLastReplId());
        String catalog = replLastIdInfo.isSetCatalog() ? StringUtils.normalizeIdentifier((String)replLastIdInfo.getCatalog()) : MetaStoreUtils.getDefaultCatalog((Configuration)jdbcResource.getConf());
        String db = StringUtils.normalizeIdentifier((String)replLastIdInfo.getDatabase());
        String table = replLastIdInfo.isSetTable() ? StringUtils.normalizeIdentifier((String)replLastIdInfo.getTable()) : null;
        List partList = replLastIdInfo.isSetPartitionList() ? replLastIdInfo.getPartitionList() : null;
        String s = jdbcResource.getSqlGenerator().getDbProduct().getPrepareTxnStmt();
        if (s != null) {
            jdbcResource.getJdbcTemplate().execute(s, ps -> null);
        }
        long dbId = this.updateDatabaseProp(jdbcResource, catalog, db, "repl.last.id", lastReplId);
        if (table != null) {
            long tableId = this.updateTableProp(jdbcResource, catalog, db, dbId, table, "repl.last.id", lastReplId);
            if (partList != null && !partList.isEmpty()) {
                this.updatePartitionProp(jdbcResource, tableId, partList, "repl.last.id", lastReplId);
            }
        }
    }

    private long updateDatabaseProp(MultiDataSourceJdbcResource jdbcResource, String catalog, String database, String prop, String propValue) throws MetaException {
        String command;
        DbEntityParam dbEntityParam;
        String query = "SELECT d.\"DB_ID\", dp.\"PARAM_KEY\", dp.\"PARAM_VALUE\" FROM \"DATABASE_PARAMS\" dp\nRIGHT JOIN \"DBS\" d ON dp.\"DB_ID\" = d.\"DB_ID\" WHERE \"NAME\" = :dbName  and \"CTLG_NAME\" = :catalog";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Going to execute query <" + query + ">");
        }
        if ((dbEntityParam = (DbEntityParam)jdbcResource.getJdbcTemplate().query(query, (SqlParameterSource)new MapSqlParameterSource().addValue("dbName", (Object)database).addValue("catalog", (Object)catalog), rs -> rs.next() ? new DbEntityParam(rs.getLong("DB_ID"), rs.getString("PARAM_KEY"), rs.getString("PARAM_VALUE")) : null)) == null) {
            throw new MetaException("DB with name " + database + " does not exist in catalog " + catalog);
        }
        if (dbEntityParam.key == null) {
            command = "INSERT INTO \"DATABASE_PARAMS\" VALUES (:dbId, :key, :value)";
        } else if (!dbEntityParam.value.equals(propValue)) {
            command = "UPDATE \"DATABASE_PARAMS\" SET \"PARAM_VALUE\" = :value WHERE \"DB_ID\" = :dbId AND \"PARAM_KEY\" = :key";
        } else {
            LOG.info("Database property: {} with value: {} already updated for db: {}", new Object[]{prop, propValue, database});
            return dbEntityParam.id;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating {} for db: {}  using command {}", new Object[]{prop, database, command});
        }
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("dbId", (Object)dbEntityParam.id).addValue("key", (Object)prop).addValue("value", (Object)propValue);
        if (jdbcResource.getJdbcTemplate().update(command, (SqlParameterSource)params) != 1) {
            throw new RuntimeException("DATABASE_PARAMS is corrupted for database: " + database);
        }
        return dbEntityParam.id;
    }

    private long updateTableProp(MultiDataSourceJdbcResource jdbcResource, String catalog, String db, long dbId, String table, String prop, String propValue) throws MetaException {
        String command;
        DbEntityParam dbEntityParam;
        String query = "SELECT t.\"TBL_ID\", tp.\"PARAM_KEY\", tp.\"PARAM_VALUE\" FROM \"TABLE_PARAMS\" tp RIGHT JOIN \"TBLS\" t ON tp.\"TBL_ID\" = t.\"TBL_ID\" WHERE t.\"DB_ID\" = :dbId AND t.\"TBL_NAME\" = :tableName";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Going to execute query <" + query + ">");
        }
        if ((dbEntityParam = (DbEntityParam)jdbcResource.getJdbcTemplate().query(query, (SqlParameterSource)new MapSqlParameterSource().addValue("tableName", (Object)table).addValue("dbId", (Object)dbId), rs -> rs.next() ? new DbEntityParam(rs.getLong("TBL_ID"), rs.getString("PARAM_KEY"), rs.getString("PARAM_VALUE")) : null)) == null) {
            throw new MetaException("Table with name " + table + " does not exist in db " + catalog + "." + db);
        }
        if (dbEntityParam.key == null) {
            command = "INSERT INTO \"TABLE_PARAMS\" VALUES (:tblId, :key, :value)";
        } else if (!dbEntityParam.value.equals(propValue)) {
            command = "UPDATE \"TABLE_PARAMS\" SET \"PARAM_VALUE\" = :value WHERE \"TBL_ID\" = :dbId AND \"PARAM_KEY\" = :key";
        } else {
            LOG.info("Database property: {} with value: {} already updated for db: {}", new Object[]{prop, propValue, db});
            return dbEntityParam.id;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating {} for table: {}  using command {}", new Object[]{prop, table, command});
        }
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("tblId", (Object)dbEntityParam.id).addValue("key", (Object)prop).addValue("value", (Object)propValue);
        if (jdbcResource.getJdbcTemplate().update(command, (SqlParameterSource)params) != 1) {
            throw new RuntimeException("TABLE_PARAMS is corrupted for table: " + table);
        }
        return dbEntityParam.id;
    }

    private void updatePartitionProp(MultiDataSourceJdbcResource jdbcResource, long tableId, List<String> partList, String prop, String propValue) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        prefix.append("SELECT p.\"PART_ID\", pp.\"PARAM_KEY\", pp.\"PARAM_VALUE\" FROM \"PARTITION_PARAMS\" pp\nRIGHT JOIN \"PARTITIONS\" p ON pp.\"PART_ID\" = p.\"PART_ID\" WHERE p.\"TBL_ID\" = :tblId AND pp.\"PARAM_KEY\" = :key");
        TxnUtils.buildQueryWithINClauseStrings(jdbcResource.getConf(), queries, prefix, suffix, partList, "\"PART_NAME\"", true, false);
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("tblId", (Object)tableId).addValue("key", (Object)prop);
        ArrayList partitionParams = new ArrayList();
        for (String query : queries) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query <" + query + ">");
            }
            jdbcResource.getJdbcTemplate().query(query, (SqlParameterSource)params, rs -> {
                while (rs.next()) {
                    partitionParams.add(new DbEntityParam(rs.getLong("PART_ID"), rs.getString("PARAM_KEY"), rs.getString("PARAM_VALUE")));
                }
            });
        }
        int maxBatchSize = MetastoreConf.getIntVar((Configuration)jdbcResource.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.JDBC_MAX_BATCH_SIZE);
        int[][] inserts = jdbcResource.getJdbcTemplate().getJdbcTemplate().batchUpdate("INSERT INTO \"PARTITION_PARAMS\" VALUES (?, ?, ?)", (Collection)partitionParams.stream().filter(p -> p.key == null).collect(Collectors.toList()), maxBatchSize, (ps, argument) -> {
            ps.setLong(1, argument.id);
            ps.setString(2, argument.key);
            ps.setString(3, propValue);
        });
        int[][] updates = jdbcResource.getJdbcTemplate().getJdbcTemplate().batchUpdate("UPDATE \"PARTITION_PARAMS\" SET \"PARAM_VALUE\" = ? WHERE \"PART_ID\" = ? AND \"PARAM_KEY\" = ?", (Collection)partitionParams.stream().filter(p -> p.key != null && !propValue.equals(p.value)).collect(Collectors.toList()), maxBatchSize, (ps, argument) -> {
            ps.setString(1, propValue);
            ps.setLong(2, argument.id);
            ps.setString(3, argument.key);
        });
        if (Arrays.stream(inserts).flatMapToInt(IntStream::of).sum() + Arrays.stream(updates).flatMapToInt(IntStream::of).sum() != partList.size()) {
            throw new RuntimeException("PARTITION_PARAMS is corrupted, update failed");
        }
    }

    private WriteSetInfo checkForWriteConflict(MultiDataSourceJdbcResource jdbcResource, long txnid) throws MetaException {
        String writeConflictQuery = jdbcResource.getSqlGenerator().addLimitClause(1, "\"COMMITTED\".\"WS_TXNID\", \"COMMITTED\".\"WS_COMMIT_ID\", \"COMMITTED\".\"WS_DATABASE\", \"COMMITTED\".\"WS_TABLE\", \"COMMITTED\".\"WS_PARTITION\", \"CUR\".\"WS_COMMIT_ID\" \"CUR_WS_COMMIT_ID\", \"CUR\".\"WS_OPERATION_TYPE\" \"CUR_OP\", \"COMMITTED\".\"WS_OPERATION_TYPE\" \"COMMITTED_OP\" FROM \"WRITE_SET\" \"COMMITTED\" INNER JOIN \"WRITE_SET\" \"CUR\" ON \"COMMITTED\".\"WS_DATABASE\"=\"CUR\".\"WS_DATABASE\" AND \"COMMITTED\".\"WS_TABLE\"=\"CUR\".\"WS_TABLE\" AND (\"COMMITTED\".\"WS_PARTITION\"=\"CUR\".\"WS_PARTITION\" OR (\"COMMITTED\".\"WS_PARTITION\" IS NULL AND \"CUR\".\"WS_PARTITION\" IS NULL)) WHERE \"CUR\".\"WS_TXNID\" <= \"COMMITTED\".\"WS_COMMIT_ID\" AND \"CUR\".\"WS_TXNID\"= :txnId AND \"COMMITTED\".\"WS_TXNID\" <> :txnId AND (\"COMMITTED\".\"WS_OPERATION_TYPE\" IN(:opUpdate, :opDelete) AND \"CUR\".\"WS_OPERATION_TYPE\" IN(:opUpdate, :opDelete))");
        LOG.debug("Going to execute query: <{}>", (Object)writeConflictQuery);
        return (WriteSetInfo)jdbcResource.getJdbcTemplate().query(writeConflictQuery, (SqlParameterSource)new MapSqlParameterSource().addValue("txnId", (Object)txnid).addValue("opUpdate", (Object)OperationType.UPDATE.getSqlConst()).addValue("opDelete", (Object)OperationType.DELETE.getSqlConst()), rs -> {
            if (rs.next()) {
                return new WriteSetInfo(rs.getLong("WS_TXNID"), rs.getLong("CUR_WS_COMMIT_ID"), rs.getLong("WS_COMMIT_ID"), rs.getString("CUR_OP"), rs.getString("COMMITTED_OP"), rs.getString("WS_DATABASE"), rs.getString("WS_TABLE"), rs.getString("WS_PARTITION"));
            }
            return null;
        });
    }

    private void moveTxnComponentsToCompleted(MultiDataSourceJdbcResource jdbcResource, long txnid, char isUpdateDelete) {
        String query = "INSERT INTO \"COMPLETED_TXN_COMPONENTS\" (\"CTC_TXNID\", \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\", \"CTC_WRITEID\", \"CTC_UPDATE_DELETE\") SELECT \"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_WRITEID\", :flag FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = :txnid AND \"TC_OPERATION_TYPE\" <> :type";
        LOG.debug("Going to execute insert <{}>", (Object)query);
        int affectedRows = jdbcResource.getJdbcTemplate().update(query, (SqlParameterSource)new MapSqlParameterSource().addValue("flag", (Object)Character.toString(isUpdateDelete), 1).addValue("txnid", (Object)txnid).addValue("type", (Object)OperationType.COMPACT.getSqlConst(), 1));
        if (affectedRows < 1) {
            LOG.info("Expected to move at least one record from txn_components to completed_txn_components when committing txn! {}", (Object)JavaUtils.txnIdToString((long)txnid));
        }
    }

    private void updateKeyValueAssociatedWithTxn(MultiDataSourceJdbcResource jdbcResource, CommitTxnRequest rqst) {
        if (!rqst.getKeyValue().getKey().startsWith("_meta")) {
            String errorMsg = "Error updating key/value in the sql backend with txnId=" + rqst.getTxnid() + ", tableId=" + rqst.getKeyValue().getTableId() + ", key=" + rqst.getKeyValue().getKey() + ", value=" + rqst.getKeyValue().getValue() + ". key should start with _meta.";
            LOG.warn(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        String query = "UPDATE \"TABLE_PARAMS\" SET \"PARAM_VALUE\" = :value WHERE \"TBL_ID\" = :id AND \"PARAM_KEY\" = :key";
        LOG.debug("Going to execute update <{}>", (Object)query);
        int affectedRows = jdbcResource.getJdbcTemplate().update(query, (SqlParameterSource)new MapSqlParameterSource().addValue("value", (Object)rqst.getKeyValue().getValue()).addValue("id", (Object)rqst.getKeyValue().getTableId()).addValue("key", (Object)rqst.getKeyValue().getKey()));
        if (affectedRows != 1) {
            String errorMsg = "Error updating key/value in the sql backend with txnId=" + rqst.getTxnid() + ", tableId=" + rqst.getKeyValue().getTableId() + ", key=" + rqst.getKeyValue().getKey() + ", value=" + rqst.getKeyValue().getValue() + ". Only one row should have been affected but " + affectedRows + " rows where affected.";
            LOG.warn(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    private void updateWSCommitIdAndCleanUpMetadata(MultiDataSourceJdbcResource jdbcResource, long txnid, TxnType txnType, Long commitId, long tempId) throws MetaException {
        ArrayList<CallSite> queryBatch = new ArrayList<CallSite>(6);
        if (commitId != null) {
            queryBatch.add((CallSite)((Object)("UPDATE \"WRITE_SET\" SET \"WS_COMMIT_ID\" = " + commitId + " WHERE \"WS_COMMIT_ID\" = " + tempId + " AND \"WS_TXNID\" = " + txnid)));
        }
        if (txnType != TxnType.READ_ONLY) {
            queryBatch.add((CallSite)((Object)("DELETE FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = " + txnid)));
        }
        queryBatch.add((CallSite)((Object)("DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_TXNID\" = " + txnid)));
        queryBatch.add((CallSite)((Object)("UPDATE \"TXNS\" SET \"TXN_STATE\" = " + String.valueOf((Object)TxnStatus.COMMITTED) + " WHERE \"TXN_ID\" = " + txnid)));
        if (txnType == TxnType.MATER_VIEW_REBUILD) {
            queryBatch.add((CallSite)((Object)("DELETE FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE \"MRL_TXN_ID\" = " + txnid)));
        }
        if (txnType == TxnType.SOFT_DELETE || MetaStoreServerUtils.isCompactionTxn(txnType)) {
            queryBatch.add((CallSite)((Object)("UPDATE \"COMPACTION_QUEUE\" SET \"CQ_NEXT_TXN_ID\" = " + commitId + ", \"CQ_COMMIT_TIME\" = " + TxnUtils.getEpochFn(jdbcResource.getDatabaseProduct()) + " WHERE \"CQ_TXN_ID\" = " + txnid)));
        }
        jdbcResource.getJdbcTemplate().getJdbcTemplate().batchUpdate(queryBatch.toArray(new String[0]));
        List<Function<List, InClauseBatchCommand>> commands = List.of(RemoveTxnsFromMinHistoryLevelCommand::new, RemoveWriteIdsFromMinHistoryCommand::new);
        for (Function<List, InClauseBatchCommand> cmd : commands) {
            jdbcResource.execute(cmd.apply((List)ImmutableList.of((Object)txnid)));
        }
    }

    private void createCommitNotificationEvent(MultiDataSourceJdbcResource jdbcResource, long txnid, TxnType txnType, List<TxnWriteDetails> txnWriteDetails) throws MetaException {
        if (this.transactionalListeners != null) {
            TxnHandler.notifyCommitOrAbortEvent(txnid, EventMessage.EventType.COMMIT_TXN, txnType, jdbcResource.getConnection(), txnWriteDetails, this.transactionalListeners);
            CompactionInfo compactionInfo = jdbcResource.execute(new GetCompactionInfoHandler(txnid, true));
            if (compactionInfo != null) {
                MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.COMMIT_COMPACTION, new CommitCompactionEvent(txnid, compactionInfo), jdbcResource.getConnection(), jdbcResource.getSqlGenerator());
            } else {
                LOG.warn("No compaction queue record found for Compaction type transaction commit. txnId:" + txnid);
            }
        }
    }

    private static class WriteSetInfo {
        final long txnId;
        final long currentCommitId;
        final long committedCommitId;
        final String currentOperationType;
        final String committedOperationType;
        final String database;
        final String table;
        final String partition;

        public WriteSetInfo(long txnId, long currentCommitId, long committedCommitId, String currentOperationType, String committedOperationType, String database, String table, String partition) {
            this.txnId = txnId;
            this.currentCommitId = currentCommitId;
            this.committedCommitId = committedCommitId;
            this.currentOperationType = currentOperationType;
            this.committedOperationType = committedOperationType;
            this.database = database;
            this.table = table;
            this.partition = partition;
        }
    }

    private static class DbEntityParam {
        final long id;
        final String key;
        final String value;

        public DbEntityParam(long id, String key, String value) {
            this.id = id;
            this.key = key;
            this.value = value;
        }
    }
}

