/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public class PreWarmVertex
extends Vertex {
    private PreWarmVertex(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism, Resource taskResource) {
        super(vertexName, processorDescriptor, parallelism, taskResource);
    }

    private PreWarmVertex(String vertexName, int parallelism, Resource taskResource) {
        this(vertexName, ProcessorDescriptor.create("org.apache.tez.runtime.library.processor.PreWarmProcessor"), parallelism, taskResource);
    }

    public static PreWarmVertexConfigBuilder createConfigBuilder(Configuration conf) {
        return new PreWarmVertexConfigBuilder(conf);
    }

    public static PreWarmVertex create(String vertexName, ProcessorDescriptor processorDescriptor, int parallelism, Resource taskResource) {
        return new PreWarmVertex(vertexName, processorDescriptor, parallelism, taskResource);
    }

    public static PreWarmVertex create(String vertexName, int parallelism, Resource taskResource) {
        return new PreWarmVertex(vertexName, parallelism, taskResource);
    }

    public static class PreWarmVertexConfigBuilder {
        String name;
        int parallelism;
        ProcessorDescriptor proc;
        Resource resource;
        Configuration conf;

        PreWarmVertexConfigBuilder(Configuration conf) {
            this.conf = conf;
        }

        public PreWarmVertexConfigBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public PreWarmVertexConfigBuilder setProcessorDescriptor(ProcessorDescriptor proc) {
            this.proc = proc;
            return this;
        }

        public PreWarmVertexConfigBuilder setResource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public PreWarmVertexConfigBuilder setParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public PreWarmVertex build() {
            if (this.name == null) {
                this.name = "_PreWarm_";
            }
            if (this.parallelism == 0) {
                this.parallelism = this.conf.getInt("tez.am.session.min.held-containers", -1);
                if (this.parallelism == -1) {
                    throw new TezUncheckedException("Prewarm parallelism must be set or specified in conf via tez.am.session.min.held-containers");
                }
            }
            if (this.proc == null) {
                this.proc = ProcessorDescriptor.create("org.apache.tez.runtime.library.processor.PreWarmProcessor");
            }
            return PreWarmVertex.create(this.name, this.proc, this.parallelism, this.resource);
        }
    }
}

