/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.security.JwtSecretProvider;
import org.apache.hadoop.yarn.api.records.ApplicationId;

public class LlapExtClientJwtHelper {
    public static final String LLAP_JWT_SUBJECT = "llap";
    public static final String LLAP_EXT_CLIENT_APP_ID = "llap_ext_client_app_id";
    private final JwtSecretProvider jwtSecretProvider;

    public LlapExtClientJwtHelper(Configuration conf) {
        this.jwtSecretProvider = JwtSecretProvider.initAndGet(conf);
    }

    public String buildJwtForLlap(ApplicationId extClientAppId) {
        return Jwts.builder().setSubject(LLAP_JWT_SUBJECT).setIssuedAt(new Date()).setId(UUID.randomUUID().toString()).claim(LLAP_EXT_CLIENT_APP_ID, (Object)extClientAppId.toString()).signWith(this.jwtSecretProvider.getEncryptionSecret()).compact();
    }

    public Jws<Claims> parseClaims(String jwt) {
        return Jwts.parser().setSigningKey(this.jwtSecretProvider.getDecryptionSecret()).parseClaimsJws(jwt);
    }
}

