/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.shared.common.error.StandardException;

class SetConstraintsConstantAction
extends DDLConstantAction {
    private final boolean deferred;
    private final List<TableName> constraints;

    SetConstraintsConstantAction(List<TableName> list, boolean bl) {
        this.constraints = list;
        this.deferred = bl;
    }

    public String toString() {
        return "SET CONSTRAINTS";
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        if (this.constraints != null) {
            for (TableName tableName : this.constraints) {
                SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(tableName.getSchemaName(), languageConnectionContext.getTransactionExecute(), true);
                ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableName.getTableName(), schemaDescriptor.getUUID());
                if (constraintDescriptor == null) {
                    throw StandardException.newException((String)"42X94", (Object[])new Object[]{"CONSTRAINT", tableName.getFullSQLName()});
                }
                String string = IdUtil.normalToDelimited(schemaDescriptor.getSchemaName()) + "." + IdUtil.normalToDelimited(constraintDescriptor.getConstraintName());
                if (arrayList.contains(string)) {
                    throw StandardException.newException((String)"42734", (Object[])new Object[]{constraintDescriptor.getConstraintName(), string});
                }
                arrayList.add((CallSite)((Object)string));
                if (this.deferred && !constraintDescriptor.deferrable()) {
                    throw StandardException.newException((String)"X0Y91.S", (Object[])new Object[]{constraintDescriptor.getConstraintName()});
                }
                languageConnectionContext.setConstraintDeferred(activation, constraintDescriptor, this.deferred);
            }
        } else {
            languageConnectionContext.setDeferredAll(activation, this.deferred);
        }
    }
}

