/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class SerializableByteBufferConverter
implements TypeConverter<Serializable, ByteBuffer> {
    private static final long serialVersionUID = 585211414298721468L;

    @Override
    public ByteBuffer toDatastoreType(Serializable memberValue) {
        ByteBuffer byteBuffer;
        if (memberValue == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(memberValue);
            }
            byteBuffer = ByteBuffer.wrap(baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new NucleusDataStoreException("Error serialising object of type " + memberValue.getClass().getName() + " to ByteBuffer", ioe);
            }
        }
        baos.close();
        return byteBuffer;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Serializable toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null || datastoreValue.limit() == 0) {
            return null;
        }
        byte[] dataStoreValueInBytes = new byte[datastoreValue.remaining()];
        datastoreValue.get(dataStoreValueInBytes);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(dataStoreValueInBytes);){
            Serializable serializable;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                serializable = (Serializable)ois.readObject();
            }
            return serializable;
        }
        catch (Exception e) {
            throw new NucleusDataStoreException("Error deserialising " + datastoreValue, e);
        }
    }
}

