/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.lineage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.model.lineage.AtlasLineageInfo;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LineageOnDemandConstraints
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AtlasLineageInfo.LineageDirection direction;
    private int inputRelationsLimit;
    private int outputRelationsLimit;
    private int depth;
    private static final int LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT = AtlasConfiguration.LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT.getInt();
    private static final int LINEAGE_ON_DEMAND_DEFAULT_DEPTH = 3;

    public LineageOnDemandConstraints() {
        this(AtlasLineageInfo.LineageDirection.BOTH, LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT, LINEAGE_ON_DEMAND_DEFAULT_NODE_COUNT, 3);
    }

    public LineageOnDemandConstraints(AtlasLineageInfo.LineageDirection direction, int inputRelationsLimit, int outputRelationsLimit, int depth) {
        this.direction = direction;
        this.inputRelationsLimit = inputRelationsLimit;
        this.outputRelationsLimit = outputRelationsLimit;
        this.depth = depth;
    }

    public AtlasLineageInfo.LineageDirection getDirection() {
        return this.direction;
    }

    public void setDirection(AtlasLineageInfo.LineageDirection direction) {
        this.direction = direction;
    }

    public int getInputRelationsLimit() {
        return this.inputRelationsLimit;
    }

    public void setInputRelationsLimit(int inputRelationsLimit) {
        this.inputRelationsLimit = inputRelationsLimit;
    }

    public int getOutputRelationsLimit() {
        return this.outputRelationsLimit;
    }

    public void setOutputRelationsLimit(int outputRelationsLimit) {
        this.outputRelationsLimit = outputRelationsLimit;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

