/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.glossary;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.atlas.model.annotation.AtlasJSON;
import org.apache.atlas.model.glossary.AtlasGlossaryBaseObject;
import org.apache.atlas.model.glossary.relations.AtlasGlossaryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedCategoryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.commons.collections.CollectionUtils;

@AtlasJSON
public class AtlasGlossaryCategory
extends AtlasGlossaryBaseObject {
    private AtlasGlossaryHeader anchor;
    private AtlasRelatedCategoryHeader parentCategory;
    private Set<AtlasRelatedCategoryHeader> childrenCategories;
    private Set<AtlasRelatedTermHeader> terms;

    public AtlasGlossaryCategory() {
    }

    public AtlasGlossaryCategory(AtlasGlossaryCategory other) {
        super(other);
        this.anchor = other.anchor;
        this.parentCategory = other.parentCategory;
        this.childrenCategories = other.childrenCategories;
        this.terms = other.terms;
    }

    public AtlasGlossaryHeader getAnchor() {
        return this.anchor;
    }

    public void setAnchor(AtlasGlossaryHeader anchor) {
        this.anchor = anchor;
    }

    public AtlasRelatedCategoryHeader getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(AtlasRelatedCategoryHeader parentCategory) {
        this.parentCategory = parentCategory;
    }

    public Set<AtlasRelatedCategoryHeader> getChildrenCategories() {
        return this.childrenCategories;
    }

    public void setChildrenCategories(Set<AtlasRelatedCategoryHeader> childrenCategories) {
        this.childrenCategories = childrenCategories;
    }

    public Set<AtlasRelatedTermHeader> getTerms() {
        return this.terms;
    }

    public void setTerms(Set<AtlasRelatedTermHeader> terms) {
        this.terms = terms;
    }

    @JsonIgnore
    public void addChild(AtlasRelatedCategoryHeader child) {
        Set<AtlasRelatedCategoryHeader> children = this.childrenCategories;
        if (children == null) {
            children = new HashSet<AtlasRelatedCategoryHeader>();
        }
        children.add(child);
        this.setChildrenCategories(children);
    }

    @JsonIgnore
    public void removeChild(AtlasRelatedCategoryHeader child) {
        if (CollectionUtils.isNotEmpty(this.childrenCategories)) {
            this.childrenCategories.remove(child);
        }
    }

    @JsonIgnore
    public void addTerm(AtlasRelatedTermHeader term) {
        Set<AtlasRelatedTermHeader> terms = this.terms;
        if (terms == null) {
            terms = new HashSet<AtlasRelatedTermHeader>();
        }
        terms.add(term);
        this.setTerms(terms);
    }

    @JsonIgnore
    public void removeTerm(AtlasRelatedTermHeader term) {
        if (CollectionUtils.isNotEmpty(this.terms)) {
            this.terms.remove(term);
        }
    }

    @Override
    @JsonIgnore
    public void setAttribute(String attrName, String attrVal) {
        Objects.requireNonNull(attrName, "AtlasGlossary attribute name");
        switch (attrName) {
            case "name": {
                this.setName(attrVal);
                break;
            }
            case "shortDescription": {
                this.setShortDescription(attrVal);
                break;
            }
            case "longDescription": {
                this.setLongDescription(attrVal);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid attribute '" + attrName + "' for object AtlasGlossaryCategory");
            }
        }
    }

    @Override
    protected StringBuilder toString(StringBuilder sb) {
        sb.append(", anchor=").append(this.anchor);
        sb.append(", parentCategory=").append(this.parentCategory);
        sb.append(", childrenCategories=").append(this.childrenCategories);
        sb.append(", terms=").append(this.terms);
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AtlasGlossaryCategory)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasGlossaryCategory category = (AtlasGlossaryCategory)o;
        return Objects.equals(this.anchor, category.anchor) && Objects.equals(this.parentCategory, category.parentCategory) && Objects.equals(this.childrenCategories, category.childrenCategories) && Objects.equals(this.terms, category.terms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.anchor, this.parentCategory, this.childrenCategories, this.terms);
    }
}

