/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.Map;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.AbstractServerSocket;
import org.snmp4j.transport.AbstractSocketEntry;
import org.snmp4j.transport.TcpTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.util.WorkerTask;

public abstract class AbstractTcpServerThread<S extends AbstractSocketEntry>
implements WorkerTask {
    private static final LogAdapter logger = LogFactory.getLogger(AbstractTcpServerThread.class);
    protected TcpTransportMapping<?> tcpTransportMapping;
    protected volatile boolean stop = false;
    protected Selector selector;
    protected final LinkedList<S> pending = new LinkedList();

    public AbstractTcpServerThread(TcpTransportMapping<?> tcpTransportMapping) throws IOException {
        this.tcpTransportMapping = tcpTransportMapping;
        this.selector = Selector.open();
    }

    protected void connectSocketToSendMessage(Address address, byte[] message, Socket s, S entry, Map<Address, S> sockets) {
        AbstractSocketEntry currentSocketEntry = (AbstractSocketEntry)sockets.putIfAbsent(address, entry);
        if (currentSocketEntry != null && currentSocketEntry.getSocket().isConnected()) {
            entry = currentSocketEntry;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Concurrent connection attempt detected, canceling this one to " + address)));
            }
            ((AbstractSocketEntry)entry).addMessage(message);
            try {
                s.close();
            }
            catch (IOException iox) {
                logger.error("Failed to close recently opened socket for '" + address + "', with " + iox.getMessage(), iox);
            }
            if (currentSocketEntry.getSocket().isConnected()) {
                this.queueNewMessage(entry);
                return;
            }
        } else if (currentSocketEntry != null && !currentSocketEntry.getSocket().isConnected()) {
            ((AbstractSocketEntry)entry).insertMessages(currentSocketEntry.getMessages());
            sockets.put(address, entry);
            try {
                currentSocketEntry.getSocket().close();
            }
            catch (IOException iox) {
                logger.error("Failed to close socket for '" + address + "', with " + iox.getMessage(), iox);
            }
        }
        this.queueNewMessage(entry);
        logger.debug((Serializable)((Object)("Trying to connect to " + address)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNewMessage(S entry) {
        LinkedList<S> linkedList = this.pending;
        synchronized (linkedList) {
            this.pending.add(entry);
        }
        this.selector.wakeup();
    }

    @Override
    public abstract void run();

    public abstract S removeSocketEntry(TcpAddress var1);

    protected void connectChannel(SelectionKey sk, TcpAddress incomingAddress) {
        block7: {
            AbstractSocketEntry entry = (AbstractSocketEntry)sk.attachment();
            try {
                SocketChannel sc = (SocketChannel)sk.channel();
                if (!sc.isConnected()) {
                    if (sc.finishConnect()) {
                        sc.configureBlocking(false);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Connected to " + entry.getPeerAddress())));
                        }
                        this.tcpTransportMapping.timeoutSocket(entry);
                        entry.removeRegistration(this.selector, 8);
                        entry.addRegistration(this.selector, 4);
                    } else {
                        entry = null;
                    }
                }
                if (entry != null) {
                    TcpAddress addr = incomingAddress == null ? entry.getPeerAddress() : incomingAddress;
                    logger.debug((Serializable)((Object)("Fire connected event for " + addr)));
                    TransportStateEvent e = new TransportStateEvent(this.tcpTransportMapping, addr, 1, null);
                    this.tcpTransportMapping.fireConnectionStateChanged(e);
                }
            }
            catch (IOException iox) {
                logger.warn(iox);
                sk.cancel();
                this.closeChannel(sk.channel());
                if (entry == null) break block7;
                this.pending.remove(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TcpAddress writeData(SelectionKey sk, TcpAddress incomingAddress) {
        AbstractSocketEntry entry = (AbstractSocketEntry)sk.attachment();
        try {
            SocketChannel sc = (SocketChannel)sk.channel();
            incomingAddress = new TcpAddress(sc.socket().getInetAddress(), sc.socket().getPort());
            if (entry != null && !entry.hasMessage()) {
                LinkedList<S> linkedList = this.pending;
                synchronized (linkedList) {
                    this.pending.remove(entry);
                    entry.removeRegistration(this.selector, 4);
                }
            }
            if (entry != null) {
                this.writeMessage(entry, sc);
            }
        }
        catch (IOException iox) {
            logger.warn(iox);
            this.closeChannel(sk.channel());
            this.removeSocketEntry(incomingAddress);
            TransportStateEvent e = new TransportStateEvent(this.tcpTransportMapping, incomingAddress, 2, iox);
            this.tcpTransportMapping.fireConnectionStateChanged(e);
        }
        return incomingAddress;
    }

    protected void closeChannel(SelectableChannel channel) {
        try {
            channel.close();
        }
        catch (IOException channelCloseException) {
            logger.warn(channelCloseException);
        }
    }

    private void writeMessage(S entry, SocketChannel sc) throws IOException {
        byte[] message = ((AbstractSocketEntry)entry).nextMessage();
        if (message != null) {
            ByteBuffer buffer = ByteBuffer.wrap(message);
            sc.write(buffer);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Sent message with length " + message.length + " to " + ((AbstractServerSocket)entry).getPeerAddress() + ": " + new OctetString(message).toHexString())));
            }
            ((AbstractSocketEntry)entry).addRegistration(this.selector, 1);
        } else {
            ((AbstractSocketEntry)entry).removeRegistration(this.selector, 4);
            if (((AbstractSocketEntry)entry).hasMessage() && !((AbstractSocketEntry)entry).isRegistered(4)) {
                ((AbstractSocketEntry)entry).addRegistration(this.selector, 4);
                logger.debug((Serializable)((Object)"Waking up selector"));
                this.selector.wakeup();
            }
        }
    }

    public void close() {
        this.stop = true;
        WorkerTask st = this.tcpTransportMapping.getListenWorkerTask();
        if (st != null) {
            st.terminate();
        }
    }

    @Override
    public void terminate() {
        this.stop = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Terminated worker task: " + this.getClass().getName())));
        }
    }

    @Override
    public void join() {
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Joining worker task: " + this.getClass().getName())));
        }
    }

    @Override
    public void interrupt() {
        this.stop = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Interrupting worker task: " + this.getClass().getName())));
        }
        this.selector.wakeup();
    }
}

