/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.AbstractByteInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class BufferByteInput<T extends ByteBuffer>
extends AbstractByteInput<T> {
    public static BufferByteInput<ByteBuffer> of(final int capacity, final ReadableByteChannel channel) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity(" + capacity + ") <= 0");
        }
        if (channel == null) {
            throw new NullPointerException("channel is null");
        }
        return new BufferByteInput<ByteBuffer>(null){

            @Override
            public int read() throws IOException {
                if (this.source == null) {
                    this.source = ByteBuffer.allocate(capacity);
                    ((ByteBuffer)this.source).position(((ByteBuffer)this.source).limit());
                }
                if (!((ByteBuffer)this.source).hasRemaining()) {
                    ((ByteBuffer)this.source).clear();
                    do {
                        if (channel.read((ByteBuffer)this.source) != -1) continue;
                        throw new EOFException("the channel has reached end-of-stream");
                    } while (((ByteBuffer)this.source).position() == 0);
                    ((ByteBuffer)this.source).flip();
                }
                return super.read();
            }

            @Override
            public void setSource(ByteBuffer source) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public BufferByteInput(T source) {
        super(source);
    }

    @Override
    public int read() throws IOException {
        return ((ByteBuffer)this.getSource()).get() & 0xFF;
    }

    @Override
    public BufferByteInput<T> source(T source) {
        return (BufferByteInput)super.source(source);
    }
}

