/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.log.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.warehouse.store.history.tsdb.HistoryDataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/logs"}, produces={"application/json"})
@Tag(name="Log Management Controller")
public class LogManagerController {
    private static final Logger log = LoggerFactory.getLogger(LogManagerController.class);
    private final HistoryDataWriter historyDataWriter;

    public LogManagerController(HistoryDataWriter historyDataWriter) {
        this.historyDataWriter = historyDataWriter;
    }

    @DeleteMapping
    @Operation(summary="Batch delete logs", description="Batch delete logs by time timestamps. Deletes multiple log entries based on their Unix nanosecond timestamps.")
    public ResponseEntity<Message<String>> batchDelete(@Parameter(description="List of Unix nanosecond timestamps for logs to delete", example="1640995200000000000") @RequestParam(required=false) List<Long> timeUnixNanos) {
        boolean result = this.historyDataWriter.batchDeleteLogs(timeUnixNanos);
        if (result) {
            return ResponseEntity.ok((Object)Message.success((String)"Logs deleted successfully"));
        }
        return ResponseEntity.ok((Object)Message.fail((byte)15, (String)"Failed to delete logs"));
    }
}

