/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.cairo.CairoException;
import io.questdb.mp.EagerThreadSetup;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import io.questdb.std.ThreadLocal;
import io.questdb.std.WeakMutableObjectPool;
import java.io.Closeable;

public class IOContextFactoryImpl<C extends IOContext<C>>
implements IOContextFactory<C>,
Closeable,
EagerThreadSetup {
    private final ThreadLocal<WeakMutableObjectPool<C>> contextPool = new ThreadLocal<WeakMutableObjectPool>(() -> new WeakMutableObjectPool(factory, poolSize));
    private volatile boolean closed = false;

    public IOContextFactoryImpl(ObjectFactory<C> factory, int poolSize) {
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void done(C context) {
        if (this.closed) {
            Misc.free(context);
        } else {
            this.contextPool.get().push(context);
        }
    }

    public void freeThreadLocal() {
        Misc.free(this.contextPool);
    }

    @Override
    public C newInstance(long fd) {
        WeakMutableObjectPool<C> pool = this.contextPool.get();
        IOContext context = (IOContext)pool.pop();
        try {
            return (C)context.of(fd);
        }
        catch (CairoException e) {
            if (e.isCritical()) {
                context.close();
            } else {
                context.clear();
                pool.push((C)context);
            }
            throw e;
        }
        catch (Throwable t) {
            context.close();
            throw t;
        }
    }

    @Override
    public void setup() {
        this.contextPool.get();
    }
}

