/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.ConcurrentQueue;
import io.questdb.mp.ConcurrentQueueSegment;
import io.questdb.mp.ConcurrentSegmentManipulator;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentPool<T> {
    public static final ConcurrentSegmentManipulator POOL_MANIPULATOR = new ConcurrentSegmentManipulator(){

        public Object dequeue(ConcurrentQueueSegment.Slot[] slots, int slotsIndex, Object unused) {
            Object val = slots[slotsIndex].item;
            slots[slotsIndex].item = null;
            return val;
        }

        public void enqueue(Object item, ConcurrentQueueSegment.Slot[] slots, int slotsIndex) {
            slots[slotsIndex].item = item;
        }
    };
    private final AtomicInteger count = new AtomicInteger(0);
    private final ConcurrentQueue<T> queue = new ConcurrentQueue<Object>(() -> null, POOL_MANIPULATOR);

    public int capacity() {
        return this.queue.capacity();
    }

    public int count() {
        return this.count.get();
    }

    public T pop() {
        T val = this.queue.tryDequeueValue(null);
        if (val != null) {
            this.count.decrementAndGet();
        }
        return val;
    }

    public void push(T item) {
        this.queue.enqueue(item);
        this.count.incrementAndGet();
    }
}

