/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.metrics.QueryTrace;
import io.questdb.mp.ConcurrentQueue;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.ValueHolderList;
import io.questdb.std.str.Utf8StringSink;
import java.io.Closeable;
import java.io.IOException;

public class QueryTracingJob
extends SynchronizedJob
implements Closeable {
    public static final String COLUMN_EXECUTION_MICROS = "execution_micros";
    public static final String COLUMN_PRINCIPAL = "principal";
    public static final String COLUMN_QUERY_TEXT = "query_text";
    public static final String COLUMN_TS = "ts";
    public static final String TABLE_NAME = "_query_trace";
    private static final int BATCH_LIMIT = 1024;
    private static final int INITIAL_CAPACITY = 128;
    private static final Log LOG = LogFactory.getLog(QueryTracingJob.class.getName());
    private final ValueHolderList<QueryTrace> buffer;
    private final CairoEngine engine;
    private final ConcurrentQueue<QueryTrace> queue;
    private final SqlExecutionContextImpl sqlExecutionContext;
    private final TableWriter tableWriter;
    private final QueryTrace trace = new QueryTrace();
    private final Utf8StringSink utf8sink = new Utf8StringSink();

    public QueryTracingJob(CairoEngine engine) throws SqlException {
        this.queue = engine.getMessageBus().getQueryTraceQueue();
        this.buffer = new ValueHolderList<QueryTrace>(QueryTrace.ITEM_FACTORY, 128);
        this.engine = engine;
        this.sqlExecutionContext = new SqlExecutionContextImpl(engine, 1).with(engine.getConfiguration().getFactoryProvider().getSecurityContextFactory().getRootContext(), null, null);
        this.tableWriter = this.acquireTableWriter();
    }

    @Override
    public void close() throws IOException {
        this.tableWriter.close();
    }

    private TableWriter acquireTableWriter() throws SqlException {
        TableToken tableToken;
        try {
            tableToken = this.engine.verifyTableName(TABLE_NAME);
        }
        catch (Exception recoverable) {
            try (SqlCompiler sqlCompiler = this.engine.getSqlCompiler();){
                CompiledQuery query = sqlCompiler.query().$("CREATE TABLE IF NOT EXISTS '").$(TABLE_NAME).$("' (").$(COLUMN_TS).$(" TIMESTAMP, ").$(COLUMN_QUERY_TEXT).$(" VARCHAR, ").$(COLUMN_EXECUTION_MICROS).$(" LONG, ").$(COLUMN_PRINCIPAL).$(" VARCHAR").$(") TIMESTAMP(").$(COLUMN_TS).$(") PARTITION BY HOUR TTL 1 DAY BYPASS WAL").compile(this.sqlExecutionContext);
                query.getOperation().execute(this.sqlExecutionContext, null);
                tableToken = this.engine.verifyTableName(TABLE_NAME);
            }
        }
        return this.engine.getWriter(tableToken, "query_tracing");
    }

    private void putVarchar(TableWriter.Row row, int column, String value) {
        this.utf8sink.clear();
        this.utf8sink.put(value);
        row.putVarchar(column, this.utf8sink);
    }

    @Override
    protected boolean runSerially() {
        this.buffer.clear();
        for (int i = 0; i < 1024 && this.queue.tryDequeue(this.buffer.peekNextHolder()); ++i) {
            this.buffer.commitNextHolder();
        }
        if (this.buffer.size() <= 0) {
            return false;
        }
        try {
            int n = this.buffer.size();
            for (int i = 0; i < n; ++i) {
                this.buffer.moveQuick(i, this.trace);
                TableWriter.Row row = this.tableWriter.newRow(this.trace.timestamp);
                this.putVarchar(row, 1, this.trace.queryText);
                row.putLong(2, this.trace.executionNanos / 1000L);
                this.putVarchar(row, 3, this.trace.principal);
                row.append();
            }
            this.tableWriter.commit();
            this.trace.clear();
        }
        catch (Exception e) {
            LOG.error().$("Failed to save query trace").$(e).$();
        }
        return false;
    }
}

