/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;

public final class WindowColumn
extends QueryColumn {
    public static final int CURRENT = 3;
    public static final int EXCLUDE_CURRENT_ROW = 1;
    public static final int EXCLUDE_GROUP = 2;
    public static final int EXCLUDE_NO_OTHERS = 4;
    public static final int EXCLUDE_TIES = 3;
    public static final ObjectFactory<WindowColumn> FACTORY = WindowColumn::new;
    public static final int FOLLOWING = 2;
    public static final int FRAMING_RANGE = 1;
    public static final int FRAMING_ROWS = 2;
    public static final int FRAMING_GROUPS = 3;
    public static final int PRECEDING = 1;
    public static final long TIME_UNIT_MICROSECOND = 1L;
    public static final long TIME_UNIT_MILLISECOND = 1000L;
    public static final long TIME_UNIT_SECOND = 1000000L;
    public static final long TIME_UNIT_MINUTE = 60000000L;
    public static final long TIME_UNIT_HOUR = 3600000000L;
    public static final long TIME_UNIT_DAY = 86400000000L;
    public static int ITME_UNIT_MICROSECOND = 1;
    private final ObjList<ExpressionNode> orderBy = new ObjList(2);
    private final IntList orderByDirection = new IntList(2);
    private final ObjList<ExpressionNode> partitionBy = new ObjList(2);
    private int exclusionKind = 4;
    private int exclusionKindPos;
    private int framingMode = 1;
    private boolean ignoreNulls = false;
    private int nullsDescPos = 0;
    private long rowsHi = Long.MAX_VALUE;
    private ExpressionNode rowsHiExpr;
    private int rowsHiExprPos;
    private long rowsHiExprTimeUnit;
    private int rowsHiKind = 3;
    private int rowsHiKindPos = 0;
    private long rowsLo = Long.MIN_VALUE;
    private ExpressionNode rowsLoExpr;
    private int rowsLoExprPos;
    private long rowsLoExprTimeUnit;
    private int rowsLoKind = 1;
    private int rowsLoKindPos = 0;

    private WindowColumn() {
    }

    public void addOrderBy(ExpressionNode node, int direction) {
        this.orderBy.add(node);
        this.orderByDirection.add(direction);
    }

    @Override
    public void clear() {
        super.clear();
        this.partitionBy.clear();
        this.orderBy.clear();
        this.orderByDirection.clear();
        this.rowsLoExpr = null;
        this.rowsLoExprPos = 0;
        this.rowsLoExprTimeUnit = 1L;
        this.rowsHiExpr = null;
        this.rowsHiExprPos = 0;
        this.rowsHiExprTimeUnit = 1L;
        this.rowsLoKind = 1;
        this.rowsLoKindPos = 0;
        this.rowsHiKind = 3;
        this.rowsHiKindPos = 0;
        this.framingMode = 1;
        this.rowsLo = Long.MIN_VALUE;
        this.rowsHi = Long.MAX_VALUE;
        this.exclusionKind = 4;
        this.exclusionKindPos = 0;
        this.ignoreNulls = false;
        this.nullsDescPos = 0;
    }

    public int getExclusionKind() {
        return this.exclusionKind;
    }

    public int getExclusionKindPos() {
        return this.exclusionKindPos;
    }

    public int getFramingMode() {
        return this.framingMode;
    }

    public int getNullsDescPos() {
        return this.nullsDescPos;
    }

    public ObjList<ExpressionNode> getOrderBy() {
        return this.orderBy;
    }

    public IntList getOrderByDirection() {
        return this.orderByDirection;
    }

    public ObjList<ExpressionNode> getPartitionBy() {
        return this.partitionBy;
    }

    public long getRowsHi() {
        return this.rowsHi;
    }

    public ExpressionNode getRowsHiExpr() {
        return this.rowsHiExpr;
    }

    public int getRowsHiExprPos() {
        return this.rowsHiExprPos;
    }

    public long getRowsHiExprTimeUnit() {
        return this.rowsHiExprTimeUnit;
    }

    public int getRowsHiKind() {
        return this.rowsHiKind;
    }

    public int getRowsHiKindPos() {
        return this.rowsHiKindPos;
    }

    public long getRowsLo() {
        return this.rowsLo;
    }

    public ExpressionNode getRowsLoExpr() {
        return this.rowsLoExpr;
    }

    public int getRowsLoExprPos() {
        return this.rowsLoExprPos;
    }

    public long getRowsLoExprTimeUnit() {
        return this.rowsLoExprTimeUnit;
    }

    public int getRowsLoKind() {
        return this.rowsLoKind;
    }

    public int getRowsLoKindPos() {
        return this.rowsLoKindPos;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public boolean isNonDefaultFrame() {
        return this.framingMode != 1 || this.rowsLoKind != 1 || this.rowsHiKind != 3 || this.rowsHiExpr != null || this.rowsLoExpr != null;
    }

    @Override
    public boolean isWindowColumn() {
        return true;
    }

    @Override
    public WindowColumn of(CharSequence alias, ExpressionNode ast) {
        return (WindowColumn)super.of(alias, ast);
    }

    public boolean requiresOrderBy() {
        return this.framingMode == 1 && (this.rowsLoKind != 1 || this.rowsHiKind != 3 && this.rowsHiKind != 2 || this.rowsHiExpr != null || this.rowsLoExpr != null) || this.framingMode == 3;
    }

    public void setExclusionKind(int exclusionKind, int exclusionKindPos) {
        this.exclusionKind = exclusionKind;
        this.exclusionKindPos = exclusionKindPos;
    }

    public void setFramingMode(int framingMode) {
        this.framingMode = framingMode;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    public void setNullsDescPos(int nullsDescPos) {
        this.nullsDescPos = nullsDescPos;
    }

    public void setRowsHi(long rowsHi) {
        this.rowsHi = rowsHi;
    }

    public void setRowsHiExpr(ExpressionNode rowsHiExpr, int rowsHiExprPos) {
        this.rowsHiExpr = rowsHiExpr;
        this.rowsHiExprPos = rowsHiExprPos;
    }

    public void setRowsHiExprTimeUnit(long rowsHiExprTimeUnit) {
        this.rowsHiExprTimeUnit = rowsHiExprTimeUnit;
    }

    public void setRowsHiKind(int rowsHiKind, int rowsHiKindPos) {
        this.rowsHiKind = rowsHiKind;
        this.rowsHiKindPos = rowsHiKindPos;
    }

    public void setRowsLo(long rowsLo) {
        this.rowsLo = rowsLo;
    }

    public void setRowsLoExpr(ExpressionNode rowsLoExpr, int rowsLoExprPos) {
        this.rowsLoExpr = rowsLoExpr;
        this.rowsLoExprPos = rowsLoExprPos;
    }

    public void setRowsLoExprTimeUnit(long rowsLoExprTimeUnit) {
        this.rowsLoExprTimeUnit = rowsLoExprTimeUnit;
    }

    public void setRowsLoKind(int rowsLoKind, int rowsLoKindPos) {
        this.rowsLoKind = rowsLoKind;
        this.rowsLoKindPos = rowsLoKindPos;
    }

    public boolean stopOrderByPropagate(ObjList<ExpressionNode> modelOrder, IntList modelOrderDirection) {
        boolean stopOrderBy;
        CharSequence token = this.getAst().token;
        if ((Chars.equalsIgnoreCase(token, "first_value") || Chars.equalsIgnoreCase(token, "last_value")) && this.orderBy.size() == 0 && modelOrder.size() == 0) {
            return true;
        }
        boolean bl = stopOrderBy = !(this.framingMode != 1 || !WindowColumn.isRangeFrameDependOnSubqueryOrderBy(this.getAst().token) || this.orderBy.size() <= 0 || this.rowsHi == 0L && this.rowsLo == Long.MIN_VALUE || this.rowsHi == Long.MAX_VALUE && this.rowsLo == Long.MIN_VALUE);
        if (stopOrderBy) {
            boolean sameOrder = true;
            if (modelOrder.size() < this.orderBy.size()) {
                sameOrder = false;
            } else {
                int max = this.orderBy.size();
                for (int i = 0; i < max; ++i) {
                    if (Chars.equalsIgnoreCase(modelOrder.getQuick((int)i).token, this.orderBy.getQuick((int)i).token) && modelOrderDirection.getQuick(i) == this.orderByDirection.getQuick(i)) continue;
                    sameOrder = false;
                    break;
                }
            }
            stopOrderBy = !sameOrder;
        }
        return stopOrderBy;
    }

    private static boolean isRangeFrameDependOnSubqueryOrderBy(CharSequence funName) {
        return !Chars.equalsIgnoreCase(funName, "row_number") && !Chars.equalsIgnoreCase(funName, "rank") && !Chars.equalsIgnoreCase(funName, "dense_rank") && !Chars.equalsIgnoreCase(funName, "lead") && !Chars.equalsIgnoreCase(funName, "lag");
    }
}

