/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.ShardedMapCursor;
import io.questdb.cairo.sql.AtomicBooleanCircuitBreaker;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.cairo.sql.async.WorkStealingStrategy;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.groupby.GroupByMergeShardJob;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.table.AsyncGroupByAtom;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.std.DirectLongLongSortedList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.tasks.GroupByMergeShardTask;
import java.util.concurrent.atomic.AtomicInteger;

class AsyncGroupByRecordCursor
implements RecordCursor {
    private static final Log LOG = LogFactory.getLog(AsyncGroupByRecordCursor.class);
    private final ObjList<GroupByFunction> groupByFunctions;
    private final AtomicBooleanCircuitBreaker mergeCircuitBreaker;
    private final SOUnboundedCountDownLatch mergeDoneLatch = new SOUnboundedCountDownLatch();
    private final AtomicInteger mergeStartedCounter = new AtomicInteger();
    private final MessageBus messageBus;
    private final VirtualRecord recordA;
    private final VirtualRecord recordB;
    private final ObjList<Function> recordFunctions;
    private final ShardedMapCursor shardedCursor = new ShardedMapCursor();
    private SqlExecutionCircuitBreaker circuitBreaker;
    private int frameLimit;
    private PageFrameSequence<AsyncGroupByAtom> frameSequence;
    private boolean isDataMapBuilt;
    private boolean isOpen;
    private MapRecordCursor mapCursor;

    public AsyncGroupByRecordCursor(ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, MessageBus messageBus) {
        this.groupByFunctions = groupByFunctions;
        this.recordFunctions = recordFunctions;
        this.messageBus = messageBus;
        this.recordA = new VirtualRecord(recordFunctions);
        this.recordB = new VirtualRecord(recordFunctions);
        this.mergeCircuitBreaker = new AtomicBooleanCircuitBreaker();
        this.isOpen = true;
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        this.buildMapConditionally();
        this.mapCursor.calculateSize(circuitBreaker, counter);
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            Misc.clearObjList(this.groupByFunctions);
            this.mapCursor = Misc.free(this.mapCursor);
            if (this.frameSequence != null) {
                LOG.debug().$("closing [shard=").$(this.frameSequence.getShard()).$(", frameCount=").$(this.frameLimit).I$();
                if (this.frameLimit > -1) {
                    this.frameSequence.await();
                }
                this.frameSequence.clear();
            }
        }
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        return this.recordB;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return (SymbolTable)((Object)this.recordFunctions.getQuick(columnIndex));
    }

    @Override
    public boolean hasNext() {
        this.buildMapConditionally();
        return this.mapCursor.hasNext();
    }

    @Override
    public void longTopK(DirectLongLongSortedList list, int columnIndex) {
        this.buildMapConditionally();
        this.mapCursor.longTopK(list, this.recordFunctions.getQuick(columnIndex));
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return ((SymbolFunction)this.recordFunctions.getQuick(columnIndex)).newSymbolTable();
    }

    @Override
    public long preComputedStateSize() {
        return this.isDataMapBuilt ? 1L : 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        if (this.mapCursor != null) {
            this.mapCursor.recordAt(((VirtualRecord)record).getBaseRecord(), atRowId);
        }
    }

    @Override
    public long size() {
        if (!this.isDataMapBuilt) {
            return -1L;
        }
        return this.mapCursor != null ? this.mapCursor.size() : -1L;
    }

    @Override
    public void toTop() {
        if (this.mapCursor != null) {
            this.mapCursor.toTop();
            GroupByUtils.toTop(this.recordFunctions);
            this.frameSequence.getAtom().toTop();
        }
    }

    private void buildMap() {
        AsyncGroupByAtom atom;
        if (this.frameLimit == -1) {
            this.frameSequence.prepareForDispatch();
            this.frameLimit = this.frameSequence.getFrameCount() - 1;
        }
        int frameIndex = -1;
        boolean allFramesActive = true;
        try {
            do {
                long cursor;
                if ((cursor = this.frameSequence.next()) > -1L) {
                    PageFrameReduceTask task = this.frameSequence.getTask(cursor);
                    LOG.debug().$("collected [shard=").$(this.frameSequence.getShard()).$(", frameIndex=").$(task.getFrameIndex()).$(", frameCount=").$(this.frameSequence.getFrameCount()).$(", active=").$(this.frameSequence.isActive()).$(", cursor=").$(cursor).I$();
                    if (task.hasError()) {
                        throw CairoException.nonCritical().position(task.getErrorMessagePosition()).put(task.getErrorMsg()).setCancellation(task.isCancelled()).setInterruption(task.isCancelled()).setOutOfMemory(task.isOutOfMemory());
                    }
                    allFramesActive &= this.frameSequence.isActive();
                    frameIndex = task.getFrameIndex();
                    this.frameSequence.collect(cursor, false);
                    continue;
                }
                if (cursor == -2L) break;
                Os.pause();
            } while (frameIndex < this.frameLimit);
        }
        catch (CairoException e) {
            if (e.isInterruption()) {
                this.throwTimeoutException();
            }
            throw e;
        }
        if (!allFramesActive) {
            this.throwTimeoutException();
        }
        if (!(atom = this.frameSequence.getAtom()).isSharded()) {
            Map dataMap = atom.mergeOwnerMap();
            this.mapCursor = dataMap.getCursor();
        } else {
            ObjList<Map> shards = this.mergeShards(atom);
            this.shardedCursor.of(shards);
            this.mapCursor = this.shardedCursor;
        }
        this.recordA.of(this.mapCursor.getRecord());
        this.recordB.of(this.mapCursor.getRecordB());
        this.isDataMapBuilt = true;
    }

    private void buildMapConditionally() {
        if (!this.isDataMapBuilt) {
            this.buildMap();
        }
    }

    private ObjList<Map> mergeShards(AsyncGroupByAtom atom) {
        this.mergeCircuitBreaker.reset();
        this.mergeStartedCounter.set(0);
        this.mergeDoneLatch.reset();
        atom.shardAll();
        int shardCount = atom.getShardCount();
        RingQueue<GroupByMergeShardTask> queue = this.messageBus.getGroupByMergeShardQueue();
        MPSequence pubSeq = this.messageBus.getGroupByMergeShardPubSeq();
        MCSequence subSeq = this.messageBus.getGroupByMergeShardSubSeq();
        WorkStealingStrategy workStealingStrategy = this.frameSequence.getWorkStealingStrategy().of(this.mergeStartedCounter);
        int queuedCount = 0;
        int ownCount = 0;
        int reclaimed = 0;
        int total = 0;
        int mergedCount = 0;
        try {
            block5: for (int i = 0; i < shardCount; ++i) {
                long cursor;
                while ((cursor = pubSeq.next()) < 0L) {
                    this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                    if (workStealingStrategy.shouldSteal(mergedCount)) {
                        atom.mergeShard(-1, i);
                        ++ownCount;
                        ++total;
                        mergedCount = this.mergeDoneLatch.getCount();
                        continue block5;
                    }
                    mergedCount = this.mergeDoneLatch.getCount();
                }
                queue.get(cursor).of(this.mergeCircuitBreaker, this.mergeStartedCounter, this.mergeDoneLatch, atom, i);
                pubSeq.done(cursor);
                ++queuedCount;
                ++total;
            }
        }
        catch (Throwable th) {
            this.mergeCircuitBreaker.cancel();
            throw th;
        }
        finally {
            while (!this.mergeDoneLatch.done(queuedCount)) {
                if (this.circuitBreaker.checkIfTripped()) {
                    this.mergeCircuitBreaker.cancel();
                }
                if (workStealingStrategy.shouldSteal(mergedCount)) {
                    long cursor = subSeq.next();
                    if (cursor > -1L) {
                        GroupByMergeShardTask task = queue.get(cursor);
                        GroupByMergeShardJob.run(-1, task, subSeq, cursor, atom);
                        ++reclaimed;
                    } else {
                        Os.pause();
                    }
                } else {
                    Os.pause();
                }
                mergedCount = this.mergeDoneLatch.getCount();
            }
        }
        if (this.mergeCircuitBreaker.checkIfTripped()) {
            this.throwTimeoutException();
        }
        atom.finalizeShardStats();
        LOG.debug().$("merge shards done [total=").$(total).$(", ownCount=").$(ownCount).$(", reclaimed=").$(reclaimed).$(", queuedCount=").$(queuedCount).I$();
        return atom.getDestShards();
    }

    private void throwTimeoutException() {
        if (this.frameSequence.getCancelReason() == 3) {
            throw CairoException.queryCancelled();
        }
        throw CairoException.queryTimedOut();
    }

    void of(PageFrameSequence<AsyncGroupByAtom> frameSequence, SqlExecutionContext executionContext) throws SqlException {
        AsyncGroupByAtom atom = frameSequence.getAtom();
        if (!this.isOpen) {
            this.isOpen = true;
            atom.reopen();
        }
        this.frameSequence = frameSequence;
        this.circuitBreaker = executionContext.getCircuitBreaker();
        Function.init(this.recordFunctions, frameSequence.getSymbolTableSource(), executionContext, null);
        this.isDataMapBuilt = false;
        this.frameLimit = -1;
    }
}

