/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.StatefulAtom;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.PerWorkerLocks;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.LongAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncFilterAtom
implements StatefulAtom,
Plannable {
    public static final LongAdder PRE_TOUCH_BLACK_HOLE = new LongAdder();
    private final IntList columnTypes;
    private final Function filter;
    private final boolean forceDisablePreTouch;
    private final ObjList<Function> perWorkerFilters;
    private final PerWorkerLocks perWorkerLocks;
    private final double preTouchThreshold;
    private boolean preTouchEnabled;
    private boolean preTouchEnabledOverride;

    public AsyncFilterAtom(@NotNull CairoConfiguration configuration, @NotNull Function filter, @Nullable ObjList<Function> perWorkerFilters, @NotNull IntList columnTypes) {
        this.filter = filter;
        this.perWorkerFilters = perWorkerFilters;
        this.perWorkerLocks = perWorkerFilters != null ? new PerWorkerLocks(configuration, perWorkerFilters.size()) : null;
        this.columnTypes = columnTypes;
        this.forceDisablePreTouch = !configuration.isSqlParallelFilterPreTouchEnabled();
        this.preTouchThreshold = configuration.getSqlParallelFilterPreTouchThreshold();
    }

    @Override
    public void close() {
        Misc.freeObjList(this.perWorkerFilters);
    }

    public Function getFilter(int filterId) {
        if (filterId == -1 || this.perWorkerFilters == null) {
            return this.filter;
        }
        return this.perWorkerFilters.getQuick(filterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.filter.init(symbolTableSource, executionContext);
        if (this.perWorkerFilters != null) {
            boolean current = executionContext.getCloneSymbolTables();
            executionContext.setCloneSymbolTables(true);
            try {
                Function.init(this.perWorkerFilters, symbolTableSource, executionContext, this.filter);
            }
            finally {
                executionContext.setCloneSymbolTables(current);
            }
        }
        this.preTouchEnabled = executionContext.isColumnPreTouchEnabled();
        this.preTouchEnabledOverride = executionContext.isColumnPreTouchEnabledOverride();
    }

    public int maybeAcquireFilter(int workerId, boolean owner, SqlExecutionCircuitBreaker circuitBreaker) {
        if (this.perWorkerLocks == null) {
            return -1;
        }
        if (workerId == -1 && owner) {
            return -1;
        }
        return this.perWorkerLocks.acquireSlot(workerId, circuitBreaker);
    }

    public void preTouchColumns(PageFrameMemoryRecord record, DirectLongList rows, long frameRowCount) {
        if (!this.isPreTouchEnabled() || !this.preTouchEnabledOverride || (double)rows.size() > (double)frameRowCount * this.preTouchThreshold) {
            return;
        }
        long sum = 0L;
        long n = rows.size();
        for (long p = 0L; p < n; ++p) {
            long r = rows.get(p);
            record.setRowIndex(r);
            block20: for (int i = 0; i < this.columnTypes.size(); ++i) {
                int columnType = this.columnTypes.getQuick(i);
                switch (ColumnType.tagOf(columnType)) {
                    case 1: {
                        sum += record.getBool(i) ? 1L : 0L;
                        continue block20;
                    }
                    case 2: {
                        sum += (long)record.getByte(i);
                        continue block20;
                    }
                    case 3: {
                        sum += (long)record.getShort(i);
                        continue block20;
                    }
                    case 4: {
                        sum += (long)record.getChar(i);
                        continue block20;
                    }
                    case 5: 
                    case 12: 
                    case 25: {
                        sum += (long)record.getInt(i);
                        continue block20;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        sum += record.getLong(i);
                        continue block20;
                    }
                    case 9: {
                        sum += (long)record.getFloat(i);
                        continue block20;
                    }
                    case 10: {
                        sum += (long)record.getDouble(i);
                        continue block20;
                    }
                    case 13: {
                        Long256 l256 = record.getLong256A(i);
                        sum += l256.getLong0();
                        continue block20;
                    }
                    case 14: {
                        sum += (long)record.getGeoByte(i);
                        continue block20;
                    }
                    case 15: {
                        sum += (long)record.getGeoShort(i);
                        continue block20;
                    }
                    case 16: {
                        sum += (long)record.getGeoInt(i);
                        continue block20;
                    }
                    case 17: {
                        sum += record.getGeoLong(i);
                        continue block20;
                    }
                    case 11: {
                        sum += (long)record.getStrLen(i);
                        continue block20;
                    }
                    case 26: {
                        sum += (long)record.getVarcharSize(i);
                        continue block20;
                    }
                    case 18: {
                        sum += record.getBinLen(i);
                        continue block20;
                    }
                    case 19: {
                        sum += record.getLong128Lo(i);
                    }
                }
            }
        }
        PRE_TOUCH_BLACK_HOLE.add(sum);
    }

    public void releaseFilter(int filterId) {
        if (this.perWorkerLocks != null) {
            this.perWorkerLocks.releaseSlot(filterId);
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.filter);
        if (this.isPreTouchEnabled()) {
            sink.val(" [pre-touch]");
        }
    }

    private boolean isPreTouchEnabled() {
        return this.preTouchEnabled && !this.forceDisablePreTouch;
    }
}

