/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.SingleRecordSink;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TimeFrame;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractAsOfJoinFastRecordCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.SymbolShortCircuit;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;
import io.questdb.std.Rows;

public final class AsOfJoinFastRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final AsOfJoinKeyedFastRecordCursor cursor;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;
    private final SymbolShortCircuit symbolShortCircuit;
    private final long toleranceInterval;

    public AsOfJoinFastRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordSink masterKeySink, RecordCursorFactory slaveFactory, RecordSink slaveKeySink, int columnSplit, SymbolShortCircuit symbolShortCircuit, JoinContext joinContext, long toleranceInterval) {
        super(metadata, joinContext, masterFactory, slaveFactory);
        assert (slaveFactory.supportsTimeFrameCursor());
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        long maxSinkTargetHeapSize = (long)configuration.getSqlHashJoinValuePageSize() * (long)configuration.getSqlHashJoinValueMaxPages();
        this.cursor = new AsOfJoinKeyedFastRecordCursor(columnSplit, NullRecordFactory.getInstance(slaveFactory.getMetadata()), masterFactory.getMetadata().getTimestampIndex(), new SingleRecordSink(maxSinkTargetHeapSize, 50), slaveFactory.getMetadata().getTimestampIndex(), new SingleRecordSink(maxSinkTargetHeapSize, 50), configuration.getSqlAsOfJoinLookAhead());
        this.symbolShortCircuit = symbolShortCircuit;
        this.toleranceInterval = toleranceInterval;
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        TimeFrameRecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getTimeFrameCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("AsOf Join Fast Scan");
        sink.attr("condition").val(this.joinContext);
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
    }

    private class AsOfJoinKeyedFastRecordCursor
    extends AbstractAsOfJoinFastRecordCursor {
        private final SingleRecordSink masterSinkTarget;
        private final SingleRecordSink slaveSinkTarget;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean origHasSlave;
        private int origSlaveFrameIndex;
        private long origSlaveRowId;

        public AsOfJoinKeyedFastRecordCursor(int columnSplit, Record nullRecord, int masterTimestampIndex, SingleRecordSink masterSinkTarget, int slaveTimestampIndex, SingleRecordSink slaveSinkTarget, int lookahead) {
            super(columnSplit, nullRecord, masterTimestampIndex, slaveTimestampIndex, lookahead);
            this.origSlaveFrameIndex = -1;
            this.origSlaveRowId = -1L;
            this.masterSinkTarget = masterSinkTarget;
            this.slaveSinkTarget = slaveSinkTarget;
        }

        @Override
        public void close() {
            super.close();
            this.masterSinkTarget.close();
            this.slaveSinkTarget.close();
        }

        @Override
        public boolean hasNext() {
            long keyedRowId;
            int slaveFrameIndex;
            boolean hasSlave;
            if (this.isMasterHasNextPending) {
                this.masterHasNext = this.masterCursor.hasNext();
                this.isMasterHasNextPending = false;
            }
            if (!this.masterHasNext) {
                return false;
            }
            if (this.origSlaveRowId != -1L) {
                this.slaveTimeFrameCursor.recordAt(this.slaveRecB, Rows.toRowID(this.origSlaveFrameIndex, this.origSlaveRowId));
            }
            this.record.hasSlave(this.origHasSlave);
            long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
            if (masterTimestamp >= this.lookaheadTimestamp) {
                this.nextSlave(masterTimestamp);
            }
            this.isMasterHasNextPending = true;
            this.origHasSlave = hasSlave = this.record.hasSlave();
            if (!hasSlave) {
                return true;
            }
            long rowId = this.slaveRecB.getRowId();
            this.origSlaveFrameIndex = slaveFrameIndex = Rows.toPartitionIndex(rowId);
            this.origSlaveRowId = keyedRowId = Rows.toLocalRowID(rowId);
            if (AsOfJoinFastRecordCursorFactory.this.symbolShortCircuit.isShortCircuit(this.masterRecord)) {
                this.record.hasSlave(false);
                return true;
            }
            this.masterSinkTarget.clear();
            AsOfJoinFastRecordCursorFactory.this.masterKeySink.copy(this.masterRecord, this.masterSinkTarget);
            TimeFrame timeFrame = this.slaveTimeFrameCursor.getTimeFrame();
            int cursorFrameIndex = timeFrame.getFrameIndex();
            this.slaveTimeFrameCursor.jumpTo(slaveFrameIndex);
            this.slaveTimeFrameCursor.open();
            long rowLo = timeFrame.getRowLo();
            int keyedFrameIndex = timeFrame.getFrameIndex();
            while (true) {
                long slaveTimestamp = this.slaveRecB.getTimestamp(this.slaveTimestampIndex);
                if (AsOfJoinFastRecordCursorFactory.this.toleranceInterval != Long.MIN_VALUE && slaveTimestamp < masterTimestamp - AsOfJoinFastRecordCursorFactory.this.toleranceInterval) {
                    this.record.hasSlave(false);
                    break;
                }
                this.slaveSinkTarget.clear();
                AsOfJoinFastRecordCursorFactory.this.slaveKeySink.copy(this.slaveRecB, this.slaveSinkTarget);
                if (this.masterSinkTarget.memeq(this.slaveSinkTarget)) break;
                if (--keyedRowId < rowLo) {
                    if (!this.slaveTimeFrameCursor.prev()) {
                        this.record.hasSlave(false);
                        break;
                    }
                    this.slaveTimeFrameCursor.open();
                    keyedFrameIndex = timeFrame.getFrameIndex();
                    keyedRowId = timeFrame.getRowHi() - 1L;
                    rowLo = timeFrame.getRowLo();
                }
                this.slaveTimeFrameCursor.recordAt(this.slaveRecB, Rows.toRowID(keyedFrameIndex, keyedRowId));
                this.circuitBreaker.statefulThrowExceptionIfTripped();
            }
            this.slaveTimeFrameCursor.jumpTo(cursorFrameIndex);
            assert (slaveFrameIndex == timeFrame.getFrameIndex());
            this.slaveTimeFrameCursor.open();
            return true;
        }

        public void of(RecordCursor masterCursor, TimeFrameRecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            super.of(masterCursor, slaveCursor);
            AsOfJoinFastRecordCursorFactory.this.symbolShortCircuit.of(slaveCursor);
            this.masterSinkTarget.reopen();
            this.slaveSinkTarget.reopen();
            this.circuitBreaker = circuitBreaker;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.origSlaveFrameIndex = -1;
            this.origSlaveRowId = -1L;
            this.origHasSlave = false;
        }
    }
}

