/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.griffin.engine.groupby.vect.AbstractCountVectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Vect;

public class CountDoubleVectorAggregateFunction
extends AbstractCountVectorAggregateFunction {
    public CountDoubleVectorAggregateFunction(int keyKind, int columnIndex, int workerCount) {
        super(columnIndex);
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourCountDouble;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntCountDouble;
        }
    }

    @Override
    public void aggregate(long address, long frameRowCount, int workerId) {
        if (address != 0L) {
            long value = Vect.countDouble(address, frameRowCount);
            this.count.add(value);
            this.aggCount.increment();
        }
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long frameRowCount) {
        if (valueAddress == 0L) {
            return this.distinctFunc.run(pRosti, keyAddress, frameRowCount);
        }
        return this.keyValueFunc.run(pRosti, keyAddress, valueAddress, frameRowCount, this.valueOffset);
    }
}

