/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class MicroTimestampSampler
implements TimestampSampler {
    private final long bucket;
    private long start;

    public MicroTimestampSampler(long bucket) {
        this.bucket = bucket;
    }

    @Override
    public long getApproxBucketSize() {
        return this.bucket;
    }

    @Override
    public long getBucketSize() {
        return this.bucket;
    }

    @Override
    public long nextTimestamp(long timestamp) {
        return timestamp + this.bucket;
    }

    @Override
    public long nextTimestamp(long timestamp, int numSteps) {
        return timestamp + (long)numSteps * this.bucket;
    }

    @Override
    public long previousTimestamp(long timestamp) {
        return timestamp - this.bucket;
    }

    @Override
    public long round(long value) {
        long q = (value - this.start) / this.bucket;
        if (value < 0L && q * this.bucket != value) {
            --q;
        }
        return this.start + q * this.bucket;
    }

    @Override
    public void setStart(long timestamp) {
        this.start = timestamp;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii("MicroTsSampler");
    }
}

