/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.BasePartitionedWindowFunction;
import io.questdb.griffin.engine.functions.window.BaseWindowFunction;
import io.questdb.griffin.engine.functions.window.WindowDoubleFunction;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class FirstValueDoubleWindowFunctionFactory
extends AbstractWindowFunctionFactory {
    public static final String NAME = "first_value";
    protected static final ArrayColumnTypes FIRST_VALUE_COLUMN_TYPES = new ArrayColumnTypes();
    private static final String SIGNATURE = "first_value(D)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        windowContext.validate(position, this.supportNullsDesc());
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (rowsHi < rowsLo) {
            return new AbstractWindowFunctionFactory.DoubleNullFunction(args.get(0), NAME, rowsLo, rowsHi, windowContext.getFramingMode() == 1, windowContext.getPartitionByRecord());
        }
        return windowContext.isIgnoreNulls() ? this.generateIgnoreNullsFunction(position, args, configuration, windowContext) : this.generateRespectNullsFunction(position, args, configuration, windowContext);
    }

    private Function generateIgnoreNullsFunction(int position, ObjList<Function> args, CairoConfiguration configuration, WindowContext windowContext) throws SqlException {
        int framingMode = windowContext.getFramingMode();
        RecordSink partitionBySink = windowContext.getPartitionBySink();
        ColumnTypes partitionByKeyTypes = windowContext.getPartitionByKeyTypes();
        VirtualRecord partitionByRecord = windowContext.getPartitionByRecord();
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (partitionByRecord != null) {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, FIRST_VALUE_COLUMN_TYPES);
                    return new FirstNotNullValueOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, FIRST_VALUE_COLUMN_TYPES);
                    return new FirstNotNullValueOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                ArrayColumnTypes columnTypes = new ArrayColumnTypes();
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, columnTypes);
                int initialBufferSize = configuration.getSqlWindowInitialRangeBufferSize();
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new FirstNotNullValueOverPartitionRangeFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, initialBufferSize, timestampIndex);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, FIRST_VALUE_COLUMN_TYPES);
                    return new FirstNotNullValueOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new FirstValueOverCurrentRowFunction(args.get(0), true);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, FIRST_VALUE_COLUMN_TYPES);
                    return new FirstNotNullValueOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                ArrayColumnTypes columnTypes = new ArrayColumnTypes();
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, columnTypes);
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new FirstNotNullValueOverPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem);
            }
        } else {
            if (framingMode == 1) {
                if (!windowContext.isOrdered() && windowContext.isDefaultFrame()) {
                    return new FirstNotNullValueOverWholeResultSetFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new FirstNotNullValueOverWholeResultSetFunction(args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                return new FirstNotNullValueOverRangeFrameFunction(rowsLo, rowsHi, args.get(0), configuration, timestampIndex);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && (rowsHi == 0L || rowsHi == Long.MAX_VALUE)) {
                    return new FirstNotNullValueOverWholeResultSetFunction(args.get(0));
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new FirstValueOverCurrentRowFunction(args.get(0), true);
                }
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new FirstNotNullValueOverRowsFrameFunction(args.get(0), rowsLo, rowsHi, mem);
            }
        }
        throw SqlException.$(position, "function not implemented for given window parameters");
    }

    private Function generateRespectNullsFunction(int position, ObjList<Function> args, CairoConfiguration configuration, WindowContext windowContext) throws SqlException {
        int framingMode = windowContext.getFramingMode();
        RecordSink partitionBySink = windowContext.getPartitionBySink();
        ColumnTypes partitionByKeyTypes = windowContext.getPartitionByKeyTypes();
        VirtualRecord partitionByRecord = windowContext.getPartitionByRecord();
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (partitionByRecord != null) {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, FIRST_VALUE_COLUMN_TYPES);
                    return new FirstValueOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, FIRST_VALUE_COLUMN_TYPES);
                    return new FirstValueOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                ArrayColumnTypes columnTypes = new ArrayColumnTypes();
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, columnTypes);
                int initialBufferSize = configuration.getSqlWindowInitialRangeBufferSize();
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new FirstValueOverPartitionRangeFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, initialBufferSize, timestampIndex);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, FIRST_VALUE_COLUMN_TYPES);
                    return new FirstValueOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new FirstValueOverCurrentRowFunction(args.get(0), false);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, FIRST_VALUE_COLUMN_TYPES);
                    return new FirstValueOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                ArrayColumnTypes columnTypes = new ArrayColumnTypes();
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, columnTypes);
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new FirstValueOverPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem);
            }
        } else {
            if (framingMode == 1) {
                if (!windowContext.isOrdered() && windowContext.isDefaultFrame()) {
                    return new FirstValueOverWholeResultSetFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new FirstValueOverWholeResultSetFunction(args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                return new FirstValueOverRangeFrameFunction(rowsLo, rowsHi, args.get(0), configuration, timestampIndex);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && (rowsHi == 0L || rowsHi == Long.MAX_VALUE)) {
                    return new FirstValueOverWholeResultSetFunction(args.get(0));
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new FirstValueOverCurrentRowFunction(args.get(0), false);
                }
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new FirstValueOverRowsFrameFunction(args.get(0), rowsLo, rowsHi, mem);
            }
        }
        throw SqlException.$(position, "function not implemented for given window parameters");
    }

    @Override
    protected boolean supportNullsDesc() {
        return true;
    }

    static {
        FIRST_VALUE_COLUMN_TYPES.add(10);
    }

    static class FirstNotNullValueOverPartitionFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        public FirstNotNullValueOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public String getName() {
            return FirstValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            double d;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            if (key.findValue() == null && Double.isFinite(d = this.arg.getDouble(record))) {
                MapValue value = key.createValue();
                value.putDouble(0, d);
            }
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.findValue();
            double val = value != null ? value.getDouble(0) : Double.NaN;
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), val);
        }
    }

    static class FirstNotNullValueOverUnboundedPartitionRowsFrameFunction
    extends FirstValueOverUnboundedPartitionRowsFrameFunction {
        public FirstNotNullValueOverUnboundedPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public void computeNext(Record record) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.findValue();
            if (mapValue != null) {
                this.value = mapValue.getDouble(0);
            } else {
                double d = this.arg.getDouble(record);
                if (Numbers.isFinite(d)) {
                    mapValue = key.createValue();
                    mapValue.putDouble(0, d);
                    this.value = d;
                } else {
                    this.value = Double.NaN;
                }
            }
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }
    }

    public static class FirstNotNullValueOverPartitionRangeFrameFunction
    extends FirstValueOverPartitionRangeFrameFunction {
        public FirstNotNullValueOverPartitionRangeFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rangeLo, long rangeHi, Function arg, MemoryARW memory, int initialBufferSize, int timestampIdx) {
            super(map, partitionByRecord, partitionBySink, rangeLo, rangeHi, arg, memory, initialBufferSize, timestampIdx);
        }

        @Override
        public void computeNext(Record record) {
            long size;
            long firstIdx;
            long startOffset;
            long capacity;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            long timestamp = record.getTimestamp(this.timestampIndex);
            if (mapValue.isNew()) {
                double d = this.arg.getDouble(record);
                capacity = this.initialBufferSize;
                startOffset = this.memory.appendAddressFor(capacity * 16L) - this.memory.getPageAddress(0);
                firstIdx = 0L;
                if (Numbers.isFinite(d)) {
                    this.memory.putLong(startOffset, timestamp);
                    this.memory.putDouble(startOffset + 8L, d);
                    size = 1L;
                    this.firstValue = this.frameIncludesCurrentValue ? d : Double.NaN;
                } else {
                    size = 0L;
                    this.firstValue = Double.NaN;
                }
            } else {
                startOffset = mapValue.getLong(0);
                size = mapValue.getLong(1);
                capacity = mapValue.getLong(2);
                firstIdx = mapValue.getLong(3);
                if (!this.frameLoBounded && size > 0L) {
                    if (firstIdx == 0L) {
                        long ts = this.memory.getLong(startOffset);
                        if (Math.abs(timestamp - ts) >= this.minDiff) {
                            firstIdx = 1L;
                            this.firstValue = this.memory.getDouble(startOffset + 8L);
                            mapValue.putLong(3, firstIdx);
                        } else {
                            this.firstValue = Double.NaN;
                        }
                    } else {
                        this.firstValue = this.memory.getDouble(startOffset + 8L);
                    }
                    return;
                }
                long newFirstIdx = firstIdx;
                boolean findNewFirstValue = false;
                long n = size;
                for (long i = 0L; i < n; ++i) {
                    long idx = (firstIdx + i) % capacity;
                    long ts = this.memory.getLong(startOffset + idx * 16L);
                    if (Math.abs(timestamp - ts) > this.maxDiff) {
                        newFirstIdx = (idx + 1L) % capacity;
                        --size;
                        continue;
                    }
                    if (Math.abs(timestamp - ts) < this.minDiff) break;
                    findNewFirstValue = true;
                    this.firstValue = this.memory.getDouble(startOffset + idx * 16L + 8L);
                    break;
                }
                firstIdx = newFirstIdx;
                double d = this.arg.getDouble(record);
                if (Numbers.isFinite(d)) {
                    if (size == capacity) {
                        this.memoryDesc.reset(capacity, startOffset, size, firstIdx, this.freeList);
                        AbstractWindowFunctionFactory.expandRingBuffer(this.memory, this.memoryDesc, 16);
                        capacity = this.memoryDesc.capacity;
                        startOffset = this.memoryDesc.startOffset;
                        firstIdx = this.memoryDesc.firstIdx;
                    }
                    this.memory.putLong(startOffset + (firstIdx + size) % capacity * 16L, timestamp);
                    this.memory.putDouble(startOffset + (firstIdx + size) % capacity * 16L + 8L, d);
                    ++size;
                }
                if (!findNewFirstValue) {
                    this.firstValue = this.frameIncludesCurrentValue ? d : Double.NaN;
                }
            }
            mapValue.putLong(0, startOffset);
            mapValue.putLong(1, size);
            mapValue.putLong(2, capacity);
            mapValue.putLong(3, firstIdx);
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }
    }

    static class FirstValueOverCurrentRowFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private final boolean ignoreNulls;
        private double value;

        FirstValueOverCurrentRowFunction(Function arg, boolean ignoreNulls) {
            super(arg);
            this.ignoreNulls = ignoreNulls;
        }

        @Override
        public void computeNext(Record record) {
            this.value = this.arg.getDouble(record);
        }

        @Override
        public double getDouble(Record rec) {
            return this.value;
        }

        @Override
        public String getName() {
            return FirstValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public boolean isIgnoreNulls() {
            return this.ignoreNulls;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }
    }

    public static class FirstNotNullValueOverPartitionRowsFrameFunction
    extends FirstValueOverPartitionRowsFrameFunction {
        public FirstNotNullValueOverPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rowsLo, long rowsHi, Function arg, MemoryARW memory) {
            super(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, arg, memory);
        }

        @Override
        public void computeNext(Record record) {
            long startOffset;
            long loIdx;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            long firstNotNullIdx = -1L;
            long count = 0L;
            if (value.isNew()) {
                loIdx = 0L;
                startOffset = this.memory.appendAddressFor((long)this.bufferSize * 8L) - this.memory.getPageAddress(0);
                value.putLong(1, startOffset);
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.memory.putDouble(startOffset + (long)i * 8L, Double.NaN);
                }
            } else {
                loIdx = value.getLong(0);
                startOffset = value.getLong(1);
                firstNotNullIdx = value.getLong(2);
                count = value.getLong(3);
            }
            if (!this.frameLoBounded) {
                if (firstNotNullIdx != -1L && count - (long)this.bufferSize >= firstNotNullIdx) {
                    this.firstValue = this.memory.getDouble(startOffset);
                    return;
                }
                double d = this.arg.getDouble(record);
                if (firstNotNullIdx == -1L && Numbers.isFinite(d)) {
                    firstNotNullIdx = count;
                    this.memory.putDouble(startOffset, d);
                    this.firstValue = this.frameIncludesCurrentValue ? d : Double.NaN;
                } else {
                    this.firstValue = Double.NaN;
                }
                value.putLong(2, firstNotNullIdx);
                value.putLong(3, count + 1L);
            } else {
                double d = this.arg.getDouble(record);
                if (firstNotNullIdx != -1L && Numbers.isFinite(this.memory.getDouble(startOffset + loIdx * 8L))) {
                    firstNotNullIdx = -1L;
                }
                if (firstNotNullIdx != -1L) {
                    this.firstValue = this.memory.getDouble(startOffset + firstNotNullIdx * 8L);
                } else {
                    boolean find = false;
                    for (int i = 0; i < this.frameSize; ++i) {
                        double res = this.memory.getDouble(startOffset + (loIdx + (long)i) % (long)this.bufferSize * 8L);
                        if (!Numbers.isFinite(res)) continue;
                        find = true;
                        firstNotNullIdx = (loIdx + (long)i) % (long)this.bufferSize;
                        this.firstValue = res;
                        break;
                    }
                    if (!find) {
                        double d2 = this.firstValue = this.frameIncludesCurrentValue ? d : Double.NaN;
                    }
                }
                if (firstNotNullIdx == loIdx) {
                    firstNotNullIdx = -1L;
                }
                value.putLong(0, (loIdx + 1L) % (long)this.bufferSize);
                value.putLong(2, firstNotNullIdx);
                this.memory.putDouble(startOffset + loIdx * 8L, d);
            }
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }
    }

    public static class FirstNotNullValueOverWholeResultSetFunction
    extends FirstValueOverWholeResultSetFunction {
        public FirstNotNullValueOverWholeResultSetFunction(Function arg) {
            super(arg);
        }

        @Override
        public void computeNext(Record record) {
            double d;
            if (!this.found && Numbers.isFinite(d = this.arg.getDouble(record))) {
                this.value = d;
                this.found = true;
            }
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            double d;
            if (!this.found && Numbers.isFinite(d = this.arg.getDouble(record))) {
                this.value = d;
                this.found = true;
            }
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }

        @Override
        public void reset() {
            super.reset();
            this.found = false;
            this.value = Double.NaN;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.found = false;
            this.value = Double.NaN;
        }
    }

    public static class FirstNotNullValueOverRangeFrameFunction
    extends FirstValueOverRangeFrameFunction
    implements Reopenable,
    WindowDoubleFunction {
        public FirstNotNullValueOverRangeFrameFunction(long rangeLo, long rangeHi, Function arg, CairoConfiguration configuration, int timestampIdx) {
            super(rangeLo, rangeHi, arg, configuration, timestampIdx);
        }

        @Override
        public void computeNext(Record record) {
            long timestamp = record.getTimestamp(this.timestampIndex);
            if (!this.frameLoBounded && this.size > 0L) {
                if (this.firstIdx == 0L) {
                    long ts = this.memory.getLong(this.startOffset);
                    if (Math.abs(timestamp - ts) >= this.minDiff) {
                        this.firstIdx = 1L;
                        this.firstValue = this.memory.getDouble(this.startOffset + 8L);
                    } else {
                        this.firstValue = Double.NaN;
                    }
                } else {
                    this.firstValue = this.memory.getDouble(this.startOffset + 8L);
                }
                return;
            }
            long newFirstIdx = this.firstIdx;
            boolean findNewFirstValue = false;
            long n = this.size;
            for (long i = 0L; i < n; ++i) {
                long idx = (this.firstIdx + i) % this.capacity;
                long ts = this.memory.getLong(this.startOffset + idx * 16L);
                if (Math.abs(timestamp - ts) > this.maxDiff) {
                    newFirstIdx = (idx + 1L) % this.capacity;
                    --this.size;
                    continue;
                }
                if (Math.abs(timestamp - ts) < this.minDiff) break;
                findNewFirstValue = true;
                this.firstValue = this.memory.getDouble(this.startOffset + idx * 16L + 8L);
                break;
            }
            this.firstIdx = newFirstIdx;
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                if (this.size == this.capacity) {
                    long newAddress = this.memory.appendAddressFor(this.capacity * 16L);
                    long oldAddress = this.memory.getPageAddress(0) + this.startOffset;
                    if (this.firstIdx == 0L) {
                        Vect.memcpy(newAddress, oldAddress, this.size * 16L);
                    } else {
                        long firstPieceSize = (this.size - this.firstIdx) * 16L;
                        Vect.memcpy(newAddress, oldAddress + this.firstIdx * 16L, firstPieceSize);
                        Vect.memcpy(newAddress + firstPieceSize, oldAddress, (this.firstIdx + this.size) % this.size * 16L);
                        this.firstIdx = 0L;
                    }
                    this.startOffset = newAddress - this.memory.getPageAddress(0);
                    this.capacity <<= 1;
                }
                this.memory.putLong(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L, timestamp);
                this.memory.putDouble(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L + 8L, d);
                ++this.size;
            }
            if (!findNewFirstValue) {
                this.firstValue = this.frameIncludesCurrentValue ? d : Double.NaN;
            }
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }
    }

    public static class FirstNotNullValueOverRowsFrameFunction
    extends FirstValueOverRowsFrameFunction
    implements Reopenable,
    WindowDoubleFunction {
        private long firstNotNullIdx = -1L;

        public FirstNotNullValueOverRowsFrameFunction(Function arg, long rowsLo, long rowsHi, MemoryARW memory) {
            super(arg, rowsLo, rowsHi, memory);
        }

        @Override
        public void computeNext(Record record) {
            if (!this.frameLoBounded) {
                if (this.firstNotNullIdx != -1L && this.count - (long)this.bufferSize >= this.firstNotNullIdx) {
                    this.firstValue = this.buffer.getDouble(0L);
                    return;
                }
                double d = this.arg.getDouble(record);
                if (this.firstNotNullIdx == -1L && Numbers.isFinite(d)) {
                    this.firstNotNullIdx = this.count;
                    this.buffer.putDouble(0L, d);
                    this.firstValue = this.frameIncludesCurrentValue ? d : Double.NaN;
                } else {
                    this.firstValue = Double.NaN;
                }
                ++this.count;
            } else {
                double d = this.arg.getDouble(record);
                if (this.firstNotNullIdx != -1L && Numbers.isFinite(this.buffer.getDouble((long)this.loIdx * 8L))) {
                    this.firstNotNullIdx = -1L;
                }
                if (this.firstNotNullIdx != -1L) {
                    this.firstValue = this.buffer.getDouble(this.firstNotNullIdx * 8L);
                } else {
                    boolean find = false;
                    for (int i = 0; i < this.frameSize; ++i) {
                        double res = this.buffer.getDouble((long)(this.loIdx + i) % (long)this.bufferSize * 8L);
                        if (!Numbers.isFinite(res)) continue;
                        find = true;
                        this.firstNotNullIdx = (this.loIdx + i) % this.bufferSize;
                        this.firstValue = res;
                        break;
                    }
                    if (!find) {
                        double d2 = this.firstValue = this.frameIncludesCurrentValue ? d : Double.NaN;
                    }
                }
                if (this.firstNotNullIdx == (long)this.loIdx) {
                    this.firstNotNullIdx = -1L;
                }
                this.buffer.putDouble((long)this.loIdx * 8L, d);
                this.loIdx = (this.loIdx + 1) % this.bufferSize;
            }
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }

        @Override
        public void reopen() {
            super.reopen();
            this.firstNotNullIdx = -1L;
        }

        @Override
        public void reset() {
            super.reset();
            this.firstNotNullIdx = -1L;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.firstNotNullIdx = -1L;
        }
    }

    static class FirstValueOverPartitionFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private double firstValue;

        public FirstValueOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public void computeNext(Record record) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            if (value.isNew()) {
                this.firstValue = this.arg.getDouble(record);
                value.putDouble(0, this.firstValue);
            } else {
                this.firstValue = value.getDouble(0);
            }
        }

        @Override
        public double getDouble(Record rec) {
            return this.firstValue;
        }

        @Override
        public String getName() {
            return FirstValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.firstValue);
        }
    }

    static class FirstValueOverUnboundedPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        protected double value;

        public FirstValueOverUnboundedPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public void computeNext(Record record) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            if (mapValue.isNew()) {
                double d = this.arg.getDouble(record);
                mapValue.putDouble(0, d);
                this.value = d;
            } else {
                this.value = mapValue.getDouble(0);
            }
        }

        @Override
        public double getDouble(Record rec) {
            return this.value;
        }

        @Override
        public String getName() {
            return FirstValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between unbounded preceding and current row)");
        }
    }

    public static class FirstValueOverPartitionRangeFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        protected static final int RECORD_SIZE = 16;
        protected final boolean frameIncludesCurrentValue;
        protected final boolean frameLoBounded;
        protected final LongList freeList = new LongList();
        protected final int initialBufferSize;
        protected final long maxDiff;
        protected final MemoryARW memory;
        protected final AbstractWindowFunctionFactory.RingBufferDesc memoryDesc = new AbstractWindowFunctionFactory.RingBufferDesc();
        protected final long minDiff;
        protected final int timestampIndex;
        protected double firstValue;

        public FirstValueOverPartitionRangeFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rangeLo, long rangeHi, Function arg, MemoryARW memory, int initialBufferSize, int timestampIdx) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.frameLoBounded = rangeLo != Long.MIN_VALUE;
            this.maxDiff = this.frameLoBounded ? Math.abs(rangeLo) : Math.abs(rangeHi);
            this.minDiff = Math.abs(rangeHi);
            this.memory = memory;
            this.initialBufferSize = initialBufferSize;
            this.timestampIndex = timestampIdx;
            this.frameIncludesCurrentValue = rangeHi == 0L;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
            this.freeList.clear();
        }

        @Override
        public void computeNext(Record record) {
            long frameSize;
            long size;
            long firstIdx;
            long startOffset;
            long capacity;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            long timestamp = record.getTimestamp(this.timestampIndex);
            double d = this.arg.getDouble(record);
            if (mapValue.isNew()) {
                capacity = this.initialBufferSize;
                startOffset = this.memory.appendAddressFor(capacity * 16L) - this.memory.getPageAddress(0);
                firstIdx = 0L;
                this.memory.putLong(startOffset, timestamp);
                this.memory.putDouble(startOffset + 8L, d);
                size = 1L;
                if (this.frameIncludesCurrentValue) {
                    this.firstValue = d;
                    frameSize = 1L;
                } else {
                    this.firstValue = Double.NaN;
                    frameSize = 0L;
                }
            } else {
                long i;
                frameSize = mapValue.getLong(0);
                startOffset = mapValue.getLong(1);
                size = mapValue.getLong(2);
                capacity = mapValue.getLong(3);
                firstIdx = mapValue.getLong(4);
                if (!this.frameLoBounded && frameSize > 0L) {
                    this.firstValue = this.memory.getDouble(startOffset + firstIdx * 16L + 8L);
                    return;
                }
                long newFirstIdx = firstIdx;
                if (this.frameLoBounded) {
                    long idx;
                    long ts;
                    long n = size;
                    for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(startOffset + (idx = (firstIdx + i) % capacity) * 16L))) > this.maxDiff; ++i) {
                        if (frameSize > 0L) {
                            --frameSize;
                        }
                        newFirstIdx = (idx + 1L) % capacity;
                        --size;
                    }
                }
                firstIdx = newFirstIdx;
                if (size == capacity) {
                    this.memoryDesc.reset(capacity, startOffset, size, firstIdx, this.freeList);
                    AbstractWindowFunctionFactory.expandRingBuffer(this.memory, this.memoryDesc, 16);
                    capacity = this.memoryDesc.capacity;
                    startOffset = this.memoryDesc.startOffset;
                    firstIdx = this.memoryDesc.firstIdx;
                }
                this.memory.putLong(startOffset + (firstIdx + size) % capacity * 16L, timestamp);
                this.memory.putDouble(startOffset + (firstIdx + size) % capacity * 16L + 8L, d);
                ++size;
                if (this.frameLoBounded) {
                    long idx;
                    long ts;
                    long diff;
                    for (i = frameSize; i < size && (diff = Math.abs((ts = this.memory.getLong(startOffset + (idx = (firstIdx + i) % capacity) * 16L)) - timestamp)) <= this.maxDiff && diff >= this.minDiff; ++i) {
                        ++frameSize;
                    }
                } else {
                    long idx;
                    long ts;
                    if (size > 0L && Math.abs(timestamp - (ts = this.memory.getLong(startOffset + (idx = firstIdx % capacity) * 16L))) >= this.minDiff) {
                        ++frameSize;
                        newFirstIdx = idx;
                    }
                    firstIdx = newFirstIdx;
                }
                this.firstValue = frameSize != 0L ? this.memory.getDouble(startOffset + firstIdx * 16L + 8L) : Double.NaN;
            }
            mapValue.putLong(0, frameSize);
            mapValue.putLong(1, startOffset);
            mapValue.putLong(2, size);
            mapValue.putLong(3, capacity);
            mapValue.putLong(4, firstIdx);
        }

        @Override
        public double getDouble(Record rec) {
            return this.firstValue;
        }

        @Override
        public String getName() {
            return FirstValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reopen() {
            super.reopen();
            this.firstValue = Double.NaN;
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
            this.freeList.clear();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" range between ");
            sink.val(this.maxDiff);
            sink.val(" preceding and ");
            if (this.minDiff == 0L) {
                sink.val("current row");
            } else {
                sink.val(this.minDiff).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
            this.freeList.clear();
        }
    }

    public static class FirstValueOverPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        protected final int bufferSize;
        protected final boolean frameIncludesCurrentValue;
        protected final boolean frameLoBounded;
        protected final int frameSize;
        protected final MemoryARW memory;
        protected double firstValue;

        public FirstValueOverPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rowsLo, long rowsHi, Function arg, MemoryARW memory) {
            super(map, partitionByRecord, partitionBySink, arg);
            if (rowsLo > Long.MIN_VALUE) {
                this.frameSize = (int)(rowsHi - rowsLo + (long)(rowsHi < 0L ? 1 : 0));
                this.bufferSize = (int)Math.abs(rowsLo);
                this.frameLoBounded = true;
            } else {
                this.frameSize = 1;
                this.bufferSize = (int)Math.abs(rowsHi);
                this.frameLoBounded = false;
            }
            this.frameIncludesCurrentValue = rowsHi == 0L;
            this.memory = memory;
        }

        @Override
        public void computeNext(Record record) {
            long startOffset;
            long count;
            long loIdx;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            double d = this.arg.getDouble(record);
            if (value.isNew()) {
                loIdx = 0L;
                count = 0L;
                startOffset = this.memory.appendAddressFor((long)this.bufferSize * 8L) - this.memory.getPageAddress(0);
                value.putLong(1, startOffset);
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.memory.putDouble(startOffset + (long)i * 8L, Double.NaN);
                }
            } else {
                loIdx = value.getLong(0);
                startOffset = value.getLong(1);
                count = value.getLong(2);
                if (!this.frameLoBounded && count == (long)this.bufferSize) {
                    this.firstValue = this.memory.getDouble(startOffset + loIdx * 8L);
                    return;
                }
            }
            this.firstValue = count == 0L && this.frameIncludesCurrentValue ? d : (count > (long)(this.bufferSize - this.frameSize) ? this.memory.getDouble(startOffset + (loIdx + (long)this.bufferSize - count) % (long)this.bufferSize * 8L) : Double.NaN);
            count = Math.min(count + 1L, (long)this.bufferSize);
            value.putLong(0, (loIdx + 1L) % (long)this.bufferSize);
            value.putLong(2, count);
            this.memory.putDouble(startOffset + loIdx * 8L, d);
        }

        @Override
        public double getDouble(Record rec) {
            return this.firstValue;
        }

        @Override
        public String getName() {
            return FirstValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.firstValue);
        }

        @Override
        public void reopen() {
            super.reopen();
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between ");
            sink.val(this.bufferSize);
            sink.val(" preceding and ");
            if (this.frameIncludesCurrentValue) {
                sink.val("current row");
            } else {
                sink.val(this.bufferSize + 1 - this.frameSize).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
        }
    }

    public static class FirstValueOverWholeResultSetFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        protected boolean found;
        protected double value = Double.NaN;

        public FirstValueOverWholeResultSetFunction(Function arg) {
            super(arg);
        }

        @Override
        public void computeNext(Record record) {
            if (!this.found) {
                this.value = this.arg.getDouble(record);
                this.found = true;
            }
        }

        @Override
        public double getDouble(Record rec) {
            return this.value;
        }

        @Override
        public String getName() {
            return FirstValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }

        @Override
        public void reset() {
            super.reset();
            this.found = false;
            this.value = Double.NaN;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.found = false;
            this.value = Double.NaN;
        }
    }

    public static class FirstValueOverRangeFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowDoubleFunction {
        protected final int RECORD_SIZE = 16;
        protected final boolean frameIncludesCurrentValue;
        protected final boolean frameLoBounded;
        protected final long initialCapacity;
        protected final long maxDiff;
        protected final MemoryARW memory;
        protected final long minDiff;
        protected final int timestampIndex;
        protected long capacity;
        protected long firstIdx;
        protected double firstValue;
        protected long frameSize;
        protected long size;
        protected long startOffset;

        public FirstValueOverRangeFrameFunction(long rangeLo, long rangeHi, Function arg, CairoConfiguration configuration, int timestampIdx) {
            super(arg);
            this.frameLoBounded = rangeLo != Long.MIN_VALUE;
            this.maxDiff = this.frameLoBounded ? Math.abs(rangeLo) : Math.abs(rangeHi);
            this.minDiff = Math.abs(rangeHi);
            this.timestampIndex = timestampIdx;
            this.capacity = this.initialCapacity = (long)(configuration.getSqlWindowStorePageSize() / 16);
            this.memory = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
            this.startOffset = this.memory.appendAddressFor(this.capacity * 16L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.frameSize = 0L;
            this.frameIncludesCurrentValue = rangeHi == 0L;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
        }

        @Override
        public void computeNext(Record record) {
            long idx;
            long ts;
            long i;
            long n;
            if (!this.frameLoBounded && this.frameSize > 0L) {
                this.firstValue = this.memory.getDouble(this.startOffset + this.firstIdx * 16L + 8L);
                return;
            }
            long timestamp = record.getTimestamp(this.timestampIndex);
            double d = this.arg.getDouble(record);
            long newFirstIdx = this.firstIdx;
            if (this.frameLoBounded) {
                n = this.size;
                for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 16L))) > this.maxDiff; ++i) {
                    if (this.frameSize > 0L) {
                        --this.frameSize;
                    }
                    newFirstIdx = (idx + 1L) % this.capacity;
                    --this.size;
                }
            }
            this.firstIdx = newFirstIdx;
            if (this.size == this.capacity) {
                long newAddress = this.memory.appendAddressFor(this.capacity * 16L);
                long oldAddress = this.memory.getPageAddress(0) + this.startOffset;
                if (this.firstIdx == 0L) {
                    Vect.memcpy(newAddress, oldAddress, this.size * 16L);
                } else {
                    long firstPieceSize = (this.size - this.firstIdx) * 16L;
                    Vect.memcpy(newAddress, oldAddress + this.firstIdx * 16L, firstPieceSize);
                    Vect.memcpy(newAddress + firstPieceSize, oldAddress, (this.firstIdx + this.size) % this.size * 16L);
                    this.firstIdx = 0L;
                }
                this.startOffset = newAddress - this.memory.getPageAddress(0);
                this.capacity <<= 1;
            }
            this.memory.putLong(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L, timestamp);
            this.memory.putDouble(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L + 8L, d);
            ++this.size;
            if (this.frameLoBounded) {
                long diff;
                n = this.size;
                for (i = this.frameSize; i < n && (diff = Math.abs((ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 16L)) - timestamp)) <= this.maxDiff && diff >= this.minDiff; ++i) {
                    ++this.frameSize;
                }
            } else {
                long idx2;
                long ts2;
                if (this.size > 0L && Math.abs(timestamp - (ts2 = this.memory.getLong(this.startOffset + (idx2 = this.firstIdx % this.capacity) * 16L))) >= this.minDiff) {
                    ++this.frameSize;
                    newFirstIdx = idx2;
                }
                this.firstIdx = newFirstIdx;
            }
            this.firstValue = this.frameSize != 0L ? this.memory.getDouble(this.startOffset + this.firstIdx * 16L + 8L) : Double.NaN;
        }

        @Override
        public double getDouble(Record rec) {
            return this.firstValue;
        }

        @Override
        public String getName() {
            return FirstValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reopen() {
            this.firstValue = Double.NaN;
            this.capacity = this.initialCapacity;
            this.startOffset = this.memory.appendAddressFor(this.capacity * 16L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.frameSize = 0L;
            this.size = 0L;
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val("range between ");
            sink.val(this.maxDiff);
            sink.val(" preceding and ");
            if (this.minDiff == 0L) {
                sink.val("current row");
            } else {
                sink.val(this.minDiff).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.firstValue = Double.NaN;
            this.capacity = this.initialCapacity;
            this.memory.truncate();
            this.startOffset = this.memory.appendAddressFor(this.capacity * 16L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.frameSize = 0L;
            this.size = 0L;
        }
    }

    public static class FirstValueOverRowsFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowDoubleFunction {
        protected final MemoryARW buffer;
        protected final int bufferSize;
        protected final boolean frameIncludesCurrentValue;
        protected final boolean frameLoBounded;
        protected final int frameSize;
        protected long count = 0L;
        protected double firstValue;
        protected int loIdx = 0;

        public FirstValueOverRowsFrameFunction(Function arg, long rowsLo, long rowsHi, MemoryARW memory) {
            super(arg);
            assert (rowsLo != Long.MIN_VALUE || rowsHi != 0L);
            if (rowsLo > Long.MIN_VALUE) {
                this.frameSize = (int)(rowsHi - rowsLo + (long)(rowsHi < 0L ? 1 : 0));
                this.bufferSize = (int)Math.abs(rowsLo);
                this.frameLoBounded = true;
            } else {
                this.bufferSize = this.frameSize = (int)Math.abs(rowsHi);
                this.frameLoBounded = false;
            }
            this.frameIncludesCurrentValue = rowsHi == 0L;
            this.buffer = memory;
            this.initBuffer();
        }

        @Override
        public void close() {
            super.close();
            this.buffer.close();
        }

        @Override
        public void computeNext(Record record) {
            if (!this.frameLoBounded && this.count > (long)(this.bufferSize - this.frameSize)) {
                this.firstValue = this.buffer.getDouble(((long)(this.loIdx + this.bufferSize) - this.count) % (long)this.bufferSize * 8L);
                return;
            }
            double d = this.arg.getDouble(record);
            this.firstValue = this.count > (long)(this.bufferSize - this.frameSize) ? this.buffer.getDouble(((long)(this.loIdx + this.bufferSize) - this.count) % (long)this.bufferSize * 8L) : (this.count == 0L && this.frameIncludesCurrentValue ? d : Double.NaN);
            this.count = Math.min(this.count + 1L, (long)this.bufferSize);
            this.buffer.putDouble((long)this.loIdx * 8L, d);
            this.loIdx = (this.loIdx + 1) % this.bufferSize;
        }

        @Override
        public double getDouble(Record rec) {
            return this.firstValue;
        }

        @Override
        public String getName() {
            return FirstValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.firstValue);
        }

        @Override
        public void reopen() {
            this.firstValue = Double.NaN;
            this.loIdx = 0;
            this.initBuffer();
            this.count = 0L;
        }

        @Override
        public void reset() {
            super.reset();
            this.buffer.close();
            this.firstValue = Double.NaN;
            this.loIdx = 0;
            this.count = 0L;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val(" rows between ");
            sink.val(this.bufferSize);
            sink.val(" preceding and ");
            if (this.frameIncludesCurrentValue) {
                sink.val("current row");
            } else {
                sink.val(this.bufferSize + 1 - this.frameSize).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.firstValue = Double.NaN;
            this.loIdx = 0;
            this.initBuffer();
            this.count = 0L;
        }

        private void initBuffer() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer.putDouble((long)i * 8L, Double.NaN);
            }
        }
    }
}

