/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.griffin.engine.functions.regex.RegexUtils;
import io.questdb.griffin.engine.functions.regex.RegexpReplaceStrFunctionFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectUtf16Sink;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class RegexpReplaceVarcharFunctionFactory
extends RegexpReplaceStrFunctionFactory {
    private static final int INITIAL_SINK_CAPACITY = 16;

    public static boolean canSkipUtf8Decoding(CharSequence pattern) {
        int n = pattern.length();
        for (int i = 0; i < n; ++i) {
            if (pattern.charAt(i) > '\u007f') {
                return false;
            }
            if (pattern.charAt(i) == ']' && (i == n - 1 || pattern.charAt(i + 1) != '+')) {
                return false;
            }
            if (pattern.charAt(i) != '\\' || i >= n - 1) continue;
            switch (pattern.charAt(i + 1)) {
                case 'B': 
                case 'D': 
                case 'S': 
                case 'W': 
                case 'b': 
                case 'd': 
                case 'p': 
                case 's': 
                case 'w': 
                case 'x': {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getSignature() {
        return "regexp_replace(\u00d8SS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        Function pattern = args.getQuick(1);
        int patternPos = argPositions.getQuick(1);
        Function replacement = args.getQuick(2);
        int replacementPos = argPositions.getQuick(2);
        this.validateInputs(pattern, patternPos, replacement, replacementPos);
        if (!pattern.isRuntimeConstant() && !replacement.isRuntimeConstant()) {
            CharSequence patternStr = pattern.getStrA(null);
            if (patternStr == null) {
                return VarcharConstant.NULL;
            }
            CharSequence replacementStr = replacement.getStrA(null);
            if (replacementStr == null) {
                return VarcharConstant.NULL;
            }
            if (patternStr.length() > 2 && patternStr.charAt(0) == '^' && patternStr.charAt(patternStr.length() - 1) == '$' && replacementStr.length() > 1 && replacementStr.charAt(0) == '$') {
                Matcher matcher = RegexUtils.createMatcher(pattern, patternPos);
                if (matcher == null) {
                    return VarcharConstant.NULL;
                }
                try {
                    int group = Numbers.parseInt(replacementStr, 1, replacementStr.length());
                    if (group > matcher.groupCount()) {
                        throw SqlException.$(replacementPos, "no group ").put(group);
                    }
                    if (RegexpReplaceVarcharFunctionFactory.canSkipUtf8Decoding(patternStr)) {
                        return new SingleGroupAsciiFunc(value, matcher, Chars.toString(replacementStr), group, position);
                    }
                    return new SingleGroupFunc(value, matcher, Chars.toString(replacementStr), group, position);
                }
                catch (NumericException numericException) {
                    // empty catch block
                }
            }
        }
        int maxLength = configuration.getStrFunctionMaxBufferLength();
        return new RegexpReplaceStrFunctionFactory.RegexpReplaceStrFunction(value, pattern, patternPos, replacement, maxLength, position);
    }

    private static class SingleGroupAsciiFunc
    extends VarcharFunction
    implements UnaryFunction {
        private final int functionPos;
        private final int group;
        private final Matcher matcher;
        private final String replacement;
        private final DirectUtf8Sink utf8SinkA;
        private final DirectUtf8Sink utf8SinkB;
        private final Function value;
        private final DirectAsciiStringView viewA = new DirectAsciiStringView();
        private final DirectAsciiStringView viewB = new DirectAsciiStringView();

        public SingleGroupAsciiFunc(Function value, Matcher matcher, String replacement, int group, int functionPos) {
            try {
                this.value = value;
                this.matcher = matcher;
                this.replacement = replacement;
                this.group = group;
                this.functionPos = functionPos;
                this.utf8SinkA = new DirectUtf8Sink(16L);
                this.utf8SinkB = new DirectUtf8Sink(16L);
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public void close() {
            UnaryFunction.super.close();
            Misc.free(this.utf8SinkA);
            Misc.free(this.utf8SinkB);
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            return this.getVarchar(rec, this.utf8SinkA, this.viewA);
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            return this.getVarchar(rec, this.utf8SinkB, this.viewB);
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isRuntimeConstant() {
            return false;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("regexp_replace(").val(this.value).val(',').val(this.matcher.pattern().toString()).val(',').val(this.replacement).val(')');
        }

        private Utf8Sequence getVarchar(Record rec, DirectUtf8Sink utf8Sink, DirectAsciiStringView view) {
            Utf8Sequence us = this.value.getVarcharA(rec);
            if (us == null) {
                return null;
            }
            if (us.ptr() != -1L) {
                view.of(us.ptr(), us.size(), us.isAscii(), us.isStable());
            } else {
                utf8Sink.clear();
                utf8Sink.put(us);
                view.of(utf8Sink.ptr(), utf8Sink.size(), utf8Sink.isAscii(), false);
            }
            this.matcher.reset(view);
            try {
                if (!this.matcher.find()) {
                    return view;
                }
                int start = this.matcher.start(this.group);
                int end = this.matcher.end(this.group);
                long ptr = view.ptr() + (long)start;
                int size = end - start;
                boolean ascii = view.isAscii() || Utf8s.isAscii(ptr, size);
                return view.of(ptr, size, ascii, view.isStable());
            }
            catch (Exception e) {
                throw CairoException.nonCritical().put("regexp_replace failed [position=").put(this.functionPos).put(", ex=").put(e.getMessage()).put(']');
            }
        }
    }

    private static class SingleGroupFunc
    extends StrFunction
    implements UnaryFunction {
        private final int functionPos;
        private final int group;
        private final Matcher matcher;
        private final String replacement;
        private final DirectUtf16Sink utf16SinkA;
        private final DirectUtf16Sink utf16SinkB;
        private final Function value;

        public SingleGroupFunc(Function value, Matcher matcher, String replacement, int group, int functionPos) {
            try {
                this.value = value;
                this.matcher = matcher;
                this.replacement = replacement;
                this.group = group;
                this.functionPos = functionPos;
                this.utf16SinkA = new DirectUtf16Sink(16L);
                this.utf16SinkB = new DirectUtf16Sink(16L);
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public void close() {
            UnaryFunction.super.close();
            Misc.free(this.utf16SinkA);
            Misc.free(this.utf16SinkB);
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.getStr(rec, this.utf16SinkA);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr(rec, this.utf16SinkB);
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isRuntimeConstant() {
            return false;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("regexp_replace(").val(this.value).val(',').val(this.matcher.pattern().toString()).val(',').val(this.replacement).val(')');
        }

        private CharSequence getStr(Record rec, DirectUtf16Sink utf16Sink) {
            Utf8Sequence us = this.value.getVarcharA(rec);
            if (us == null) {
                return null;
            }
            utf16Sink.clear();
            if (us.isAscii()) {
                utf16Sink.putAscii(us);
            } else {
                Utf8s.utf8ToUtf16(us, utf16Sink);
            }
            this.matcher.reset(utf16Sink);
            try {
                if (!this.matcher.find()) {
                    return utf16Sink.subSequence(0, utf16Sink.length());
                }
                return utf16Sink.subSequence(this.matcher.start(this.group), this.matcher.end(this.group));
            }
            catch (Exception e) {
                throw CairoException.nonCritical().put("regexp_replace failed [position=").put(this.functionPos).put(", ex=").put(e.getMessage()).put(']');
            }
        }
    }

    private static class DirectAsciiStringView
    implements CharSequence,
    DirectUtf8Sequence {
        private boolean ascii;
        private long ptr;
        private int size;
        private boolean stable;

        private DirectAsciiStringView() {
        }

        @Override
        @NotNull
        public CharSequence asAsciiCharSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte byteAt(int i) {
            return Unsafe.getUnsafe().getByte(this.ptr + (long)i);
        }

        @Override
        public char charAt(int i) {
            return (char)Unsafe.getUnsafe().getByte(this.ptr + (long)i);
        }

        @Override
        public boolean isAscii() {
            return this.ascii;
        }

        @Override
        public boolean isStable() {
            return this.stable;
        }

        @Override
        public int length() {
            return this.size;
        }

        public DirectAsciiStringView of(long ptr, int size, boolean ascii, boolean stable) {
            this.ptr = ptr;
            this.size = size;
            this.ascii = ascii;
            this.stable = stable;
            return this;
        }

        @Override
        public long ptr() {
            return this.ptr;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String toString() {
            return Utf8s.stringFromUtf8Bytes(this);
        }
    }
}

