/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.eq.EqStrFunctionFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLikeStrFunctionFactory
implements FunctionFactory {
    public static String escapeSpecialChars(CharSequence pattern, CharSequence prev) throws SqlException {
        int len = pattern.length();
        StringSink sink = Misc.getThreadLocalSink();
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (c == '_') {
                sink.put('.');
                continue;
            }
            if (c == '%') {
                sink.put(".*?");
                continue;
            }
            if ("[](){}.*+?$^|#".indexOf(c) != -1) {
                sink.put("\\");
                sink.put(c);
                continue;
            }
            if (c == '\\') {
                if (++i >= len) {
                    throw SqlException.parserErr(i - 1, pattern, "LIKE pattern must not end with escape character");
                }
                c = pattern.charAt(i);
                if ("[](){}.*+?$^|#\\".indexOf(c) != -1) {
                    sink.put("\\");
                    sink.put(c);
                    continue;
                }
                sink.put(c);
                continue;
            }
            sink.put(c);
        }
        if (Chars.equalsNc((CharSequence)sink, prev)) {
            return null;
        }
        return Chars.toString(sink);
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        Function pattern = args.getQuick(1);
        if (pattern.isConstant()) {
            int len;
            CharSequence likeSeq = pattern.getStrA(null);
            if (likeSeq != null && (len = likeSeq.length()) > 0) {
                if (AbstractLikeStrFunctionFactory.countChar(likeSeq, '_') == 0 && AbstractLikeStrFunctionFactory.countChar(likeSeq, '\\') == 0) {
                    int anyCount = AbstractLikeStrFunctionFactory.countChar(likeSeq, '%');
                    if (anyCount == 1) {
                        if (len == 1) {
                            EqStrFunctionFactory.NullCheckFunc notNullFunc = new EqStrFunctionFactory.NullCheckFunc(value);
                            notNullFunc.setNegated();
                            return notNullFunc;
                        }
                        if (likeSeq.charAt(0) == '%') {
                            String patternStr = likeSeq.subSequence(1, len).toString();
                            if (this.isCaseInsensitive()) {
                                return new ConstIEndsWithStrFunction(value, patternStr);
                            }
                            return new ConstEndsWithStrFunction(value, patternStr);
                        }
                        if (likeSeq.charAt(len - 1) == '%') {
                            String patternStr = likeSeq.subSequence(0, len - 1).toString();
                            if (this.isCaseInsensitive()) {
                                return new ConstIStartsWithStrFunction(value, patternStr);
                            }
                            return new ConstStartsWithStrFunction(value, patternStr);
                        }
                    } else if (anyCount == 2) {
                        if (len == 2) {
                            EqStrFunctionFactory.NullCheckFunc notNullFunc = new EqStrFunctionFactory.NullCheckFunc(value);
                            notNullFunc.setNegated();
                            return notNullFunc;
                        }
                        if (likeSeq.charAt(0) == '%' && likeSeq.charAt(len - 1) == '%') {
                            String patternStr = likeSeq.subSequence(1, len - 1).toString();
                            if (this.isCaseInsensitive()) {
                                return new ConstIContainsStrFunction(value, patternStr);
                            }
                            return new ConstContainsStrFunction(value, patternStr);
                        }
                    }
                }
                String p = AbstractLikeStrFunctionFactory.escapeSpecialChars(likeSeq, null);
                assert (p != null);
                int flags = 32;
                if (this.isCaseInsensitive()) {
                    flags |= 2;
                    p = p.toLowerCase();
                }
                return new ConstLikeStrFunction(value, Pattern.compile(p, flags).matcher(""));
            }
            return BooleanConstant.FALSE;
        }
        if (pattern.isRuntimeConstant()) {
            return new BindLikeStrFunction(value, pattern, this.isCaseInsensitive());
        }
        throw SqlException.$(argPositions.getQuick(1), "use constant or bind variable");
    }

    static int countChar(@NotNull CharSequence seq, char c) {
        int count = 0;
        int n = seq.length();
        for (int i = 0; i < n; ++i) {
            if (seq.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    protected abstract boolean isCaseInsensitive();

    static class ConstIEndsWithStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final Function value;

        public ConstIEndsWithStrFunction(Function value, String pattern) {
            this.value = value;
            this.pattern = pattern.toLowerCase();
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.value.getStrA(rec);
            return Chars.endsWithLowerCase(cs, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ilike ");
            sink.val('%');
            sink.val(this.pattern);
        }
    }

    private static class ConstEndsWithStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final Function value;

        public ConstEndsWithStrFunction(Function value, String pattern) {
            this.value = value;
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.value.getStrA(rec);
            return Chars.endsWith(cs, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" like ");
            sink.val('%');
            sink.val(this.pattern);
        }
    }

    static class ConstIStartsWithStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final Function value;

        public ConstIStartsWithStrFunction(Function value, String pattern) {
            this.value = value;
            this.pattern = pattern.toLowerCase();
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.value.getStrA(rec);
            return Chars.startsWithLowerCase(cs, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ilike ");
            sink.val(this.pattern);
            sink.val('%');
        }
    }

    private static class ConstStartsWithStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final Function value;

        public ConstStartsWithStrFunction(Function value, String pattern) {
            this.value = value;
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.value.getStrA(rec);
            return Chars.startsWith(cs, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" like ");
            sink.val(this.pattern);
            sink.val('%');
        }
    }

    static class ConstIContainsStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final Function value;

        public ConstIContainsStrFunction(Function value, String pattern) {
            this.value = value;
            this.pattern = pattern.toLowerCase();
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.value.getStrA(rec);
            if (cs == null) {
                return false;
            }
            return Chars.containsLowerCase(cs, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ilike ");
            sink.val('%');
            sink.val(this.pattern);
            sink.val('%');
        }
    }

    private static class ConstContainsStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final String pattern;
        private final Function value;

        public ConstContainsStrFunction(Function value, String pattern) {
            this.value = value;
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.value.getStrA(rec);
            if (cs == null) {
                return false;
            }
            return Chars.contains(cs, this.pattern);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" like ");
            sink.val('%');
            sink.val(this.pattern);
            sink.val('%');
        }
    }

    static class ConstLikeStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Matcher matcher;
        private final Function value;

        public ConstLikeStrFunction(Function value, Matcher matcher) {
            this.value = value;
            this.matcher = matcher;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.value.getStrA(rec);
            return cs != null && this.matcher.reset(cs).matches();
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ~ ");
            sink.val(this.matcher.pattern().toString());
            if ((this.matcher.pattern().flags() & 2) != 0) {
                sink.val(" [case-sensitive]");
            }
        }
    }

    static class BindLikeStrFunction
    extends BooleanFunction
    implements BinaryFunction {
        private final boolean caseInsensitive;
        private final Function pattern;
        private final Function value;
        private String lastPattern = null;
        private Matcher matcher;

        public BindLikeStrFunction(Function value, Function pattern, boolean caseInsensitive) {
            this.value = value;
            this.pattern = pattern;
            this.caseInsensitive = caseInsensitive;
        }

        @Override
        public boolean getBool(Record rec) {
            if (this.matcher != null) {
                CharSequence cs = this.value.getStrA(rec);
                return cs != null && this.matcher.reset(cs).matches();
            }
            return false;
        }

        @Override
        public Function getLeft() {
            return this.value;
        }

        @Override
        public Function getRight() {
            return this.pattern;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            CharSequence patternValue = this.pattern.getStrA(null);
            if (patternValue != null && patternValue.length() > 0) {
                String p = AbstractLikeStrFunctionFactory.escapeSpecialChars(patternValue, this.lastPattern);
                if (p != null) {
                    int flags = 32;
                    if (this.caseInsensitive) {
                        flags |= 2;
                        p = p.toLowerCase();
                    }
                    this.matcher = Pattern.compile(p, flags).matcher("");
                    this.lastPattern = p;
                }
            } else {
                this.lastPattern = null;
                this.matcher = null;
            }
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.value);
            sink.val(" ~ ");
            sink.val(this.pattern);
            if (!this.caseInsensitive) {
                sink.val(" [case-sensitive]");
            }
        }
    }
}

