/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SqrtDoubleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "sqrt(D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new SqrtFunction(args.getQuick(0));
    }

    private static class SqrtFunction
    extends DoubleFunction
    implements UnaryFunction {
        final Function function;

        public SqrtFunction(Function function) {
            this.function = function;
        }

        @Override
        public Function getArg() {
            return this.function;
        }

        @Override
        public double getDouble(Record rec) {
            double value = this.function.getDouble(rec);
            return Math.sqrt(value);
        }

        @Override
        public String getName() {
            return "sqrt";
        }
    }
}

