/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;

class OffsetTimestampFunction
extends TimestampFunction
implements UnaryFunction {
    private final long offset;
    private final Function timestamp;

    public OffsetTimestampFunction(Function timestamp, long offset) {
        this.timestamp = timestamp;
        this.offset = offset;
    }

    @Override
    public Function getArg() {
        return this.timestamp;
    }

    @Override
    public long getTimestamp(Record rec) {
        return this.timestamp.getTimestamp(rec) + this.offset;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.timestamp).val('+').val(this.offset);
    }
}

