/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class IntervalStartFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "interval_start(\u0394)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends TimestampFunction
    implements UnaryFunction {
        private final Function intervalFunc;

        public Func(Function intervalFunc) {
            this.intervalFunc = intervalFunc;
        }

        @Override
        public Function getArg() {
            return this.intervalFunc;
        }

        @Override
        public long getTimestamp(Record rec) {
            return this.intervalFunc.getInterval(rec).getLo();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("interval_start(").val(this.intervalFunc).val(')');
        }
    }
}

