/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.file.BlockFileReader;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.mv.MatViewState;
import io.questdb.cairo.mv.MatViewStateReader;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.catalogue.TablesFunctionFactory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;

public class MatViewsFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog(MatViewsFunctionFactory.class);

    public static String getIntervalUnit(char unit) {
        switch (unit) {
            case 'm': {
                return "MINUTE";
            }
            case 'h': {
                return "HOUR";
            }
            case 'd': {
                return "DAY";
            }
            case 'w': {
                return "WEEK";
            }
            case 'y': {
                return "YEAR";
            }
            case 'M': {
                return "MONTH";
            }
        }
        return null;
    }

    @Override
    public String getSignature() {
        return "materialized_views()";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new CursorFunction(new MatViewsCursorFactory(sqlExecutionContext.getCairoEngine())){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    private static class MatViewsCursorFactory
    implements RecordCursorFactory {
        private static final int COLUMN_VIEW_NAME = 0;
        private static final int COLUMN_REFRESH_TYPE = 1;
        private static final int COLUMN_BASE_TABLE_NAME = 2;
        private static final int COLUMN_LAST_REFRESH_START_TIMESTAMP = 3;
        private static final int COLUMN_LAST_REFRESH_FINISH_TIMESTAMP = 4;
        private static final int COLUMN_VIEW_SQL = 5;
        private static final int COLUMN_TABLE_DIR_NAME = 6;
        private static final int COLUMN_INVALIDATION_REASON = 7;
        private static final int COLUMN_VIEW_STATUS = 8;
        private static final int COLUMN_REFRESH_PERIOD_HI = 9;
        private static final int COLUMN_REFRESH_BASE_TABLE_TXN = 10;
        private static final int COLUMN_APPLIED_BASE_TABLE_TXN = 11;
        private static final int COLUMN_REFRESH_LIMIT = 12;
        private static final int COLUMN_REFRESH_LIMIT_UNIT = 13;
        private static final int COLUMN_TIMER_TIME_ZONE = 14;
        private static final int COLUMN_TIMER_START = 15;
        private static final int COLUMN_TIMER_INTERVAL = 16;
        private static final int COLUMN_TIMER_INTERVAL_UNIT = 17;
        private static final int COLUMN_PERIOD_LENGTH = 18;
        private static final int COLUMN_PERIOD_LENGTH_UNIT = 19;
        private static final int COLUMN_PERIOD_DELAY = 20;
        private static final int COLUMN_PERIOD_DELAY_UNIT = 21;
        private static final RecordMetadata METADATA;
        private final ViewsListCursor cursor;

        public MatViewsCursorFactory(CairoEngine engine) {
            this.cursor = new ViewsListCursor(engine);
        }

        @Override
        public void close() {
            Misc.free(this.cursor);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public RecordMetadata getMetadata() {
            return METADATA;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("materialized_views()");
        }

        static {
            GenericRecordMetadata metadata = new GenericRecordMetadata();
            metadata.add(new TableColumnMetadata("view_name", 11));
            metadata.add(new TableColumnMetadata("refresh_type", 11));
            metadata.add(new TableColumnMetadata("base_table_name", 11));
            metadata.add(new TableColumnMetadata("last_refresh_start_timestamp", 8));
            metadata.add(new TableColumnMetadata("last_refresh_finish_timestamp", 8));
            metadata.add(new TableColumnMetadata("view_sql", 11));
            metadata.add(new TableColumnMetadata("view_table_dir_name", 11));
            metadata.add(new TableColumnMetadata("invalidation_reason", 11));
            metadata.add(new TableColumnMetadata("view_status", 11));
            metadata.add(new TableColumnMetadata("refresh_period_hi", 8));
            metadata.add(new TableColumnMetadata("refresh_base_table_txn", 6));
            metadata.add(new TableColumnMetadata("base_table_txn", 6));
            metadata.add(new TableColumnMetadata("refresh_limit", 5));
            metadata.add(new TableColumnMetadata("refresh_limit_unit", 11));
            metadata.add(new TableColumnMetadata("timer_time_zone", 11));
            metadata.add(new TableColumnMetadata("timer_start", 8));
            metadata.add(new TableColumnMetadata("timer_interval", 5));
            metadata.add(new TableColumnMetadata("timer_interval_unit", 11));
            metadata.add(new TableColumnMetadata("period_length", 5));
            metadata.add(new TableColumnMetadata("period_length_unit", 11));
            metadata.add(new TableColumnMetadata("period_delay", 5));
            metadata.add(new TableColumnMetadata("period_delay_unit", 11));
            METADATA = metadata;
        }

        private static class ViewsListCursor
        implements NoRandomAccessRecordCursor {
            private final CairoEngine engine;
            private final Path path;
            private final MatViewsRecord record = new MatViewsRecord();
            private final BlockFileReader viewStateFileReader;
            private final MatViewStateReader viewStateReader = new MatViewStateReader();
            private final ObjList<TableToken> viewTokens = new ObjList();
            private int viewIndex = 0;

            public ViewsListCursor(CairoEngine engine) {
                this.engine = engine;
                this.viewStateFileReader = new BlockFileReader(engine.getConfiguration());
                this.path = new Path();
            }

            @Override
            public void close() {
                Misc.free(this.path);
                Misc.free(this.viewStateFileReader);
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() throws DataUnavailableException {
                CairoConfiguration configuration = this.engine.getConfiguration();
                this.path.of(configuration.getDbRoot());
                int pathLen = this.path.size();
                int n = this.viewTokens.size();
                while (this.viewIndex < n) {
                    block6: {
                        MatViewDefinition viewDefinition;
                        TableToken viewToken = this.viewTokens.get(this.viewIndex);
                        if (this.engine.getTableTokenIfExists(viewToken.getTableName()) != null && (viewDefinition = this.engine.getMatViewGraph().getViewDefinition(viewToken)) != null) {
                            MatViewState state;
                            this.viewStateReader.clear();
                            boolean isMatViewStateExists = TableUtils.isMatViewStateFileExists(configuration, this.path, viewToken.getDirName());
                            if (isMatViewStateExists) {
                                try {
                                    this.viewStateFileReader.of(this.path.trimTo(pathLen).concat(viewToken.getDirName()).concat("_mv.s").$());
                                    this.viewStateReader.of(this.viewStateFileReader, viewToken);
                                }
                                catch (CairoException e) {
                                    LOG.info().$("could not read materialized view state file [view=").$safe(viewToken.getTableName()).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                                    break block6;
                                }
                            }
                            long lastPeriodHi = this.viewStateReader.getLastPeriodHi();
                            long lastRefreshedBaseTxn = this.viewStateReader.getLastRefreshBaseTxn();
                            long lastRefreshTimestamp = this.viewStateReader.getLastRefreshTimestamp();
                            TableToken baseTableToken = this.engine.getTableTokenIfExists(viewDefinition.getBaseTableName());
                            long lastAppliedBaseTxn = baseTableToken != null ? this.engine.getTableSequencerAPI().getTxnTracker(baseTableToken).getWriterTxn() : -1L;
                            int refreshLimitHoursOrMonths = viewDefinition.getRefreshLimitHoursOrMonths();
                            int periodLength = viewDefinition.getPeriodLength();
                            char periodLengthUnit = viewDefinition.getPeriodLengthUnit();
                            int periodDelay = viewDefinition.getPeriodDelay();
                            char periodDelayUnit = viewDefinition.getPeriodDelayUnit();
                            long timerStart = Long.MIN_VALUE;
                            int timerInterval = 0;
                            char timerIntervalUnit = '\u0000';
                            if (viewDefinition.getRefreshType() == 1 || periodLength > 0) {
                                timerStart = viewDefinition.getTimerStart();
                                timerInterval = viewDefinition.getTimerInterval();
                                timerIntervalUnit = viewDefinition.getTimerUnit();
                            }
                            long lastRefreshStartTimestamp = (state = this.engine.getMatViewStateStore().getViewState(viewToken)) != null ? state.getLastRefreshStartTimestamp() : Long.MIN_VALUE;
                            this.record.of(viewDefinition, lastRefreshStartTimestamp, lastRefreshTimestamp, lastPeriodHi, lastRefreshedBaseTxn, lastAppliedBaseTxn, this.viewStateReader.getInvalidationReason(), this.viewStateReader.isInvalid(), refreshLimitHoursOrMonths, timerStart, timerInterval, timerIntervalUnit, periodLength, periodLengthUnit, periodDelay, periodDelayUnit);
                            ++this.viewIndex;
                            return true;
                        }
                    }
                    ++this.viewIndex;
                }
                return false;
            }

            @Override
            public long preComputedStateSize() {
                return 0L;
            }

            @Override
            public long size() throws DataUnavailableException {
                return -1L;
            }

            @Override
            public void toTop() {
                this.viewTokens.clear();
                this.engine.getMatViewGraph().getViews(this.viewTokens);
                this.viewIndex = 0;
            }

            private static class MatViewsRecord
            implements Record {
                private final StringSink invalidationReason = new StringSink();
                private boolean invalid;
                private long lastAppliedBaseTxn;
                private long lastPeriodHi;
                private long lastRefreshFinishTimestamp;
                private long lastRefreshStartTimestamp;
                private long lastRefreshTxn;
                private int periodDelay;
                private char periodDelayUnit;
                private int periodLength;
                private char periodLengthUnit;
                private int refreshLimitHoursOrMonths;
                private int timerInterval;
                private char timerIntervalUnit;
                private long timerStart;
                private MatViewDefinition viewDefinition;

                private MatViewsRecord() {
                }

                @Override
                public int getInt(int col) {
                    switch (col) {
                        case 12: {
                            return TablesFunctionFactory.getTtlValue(this.refreshLimitHoursOrMonths);
                        }
                        case 16: {
                            return this.timerInterval;
                        }
                        case 18: {
                            return this.periodLength;
                        }
                        case 20: {
                            return this.periodDelay;
                        }
                    }
                    return 0;
                }

                @Override
                public long getLong(int col) {
                    switch (col) {
                        case 3: {
                            return this.lastRefreshStartTimestamp;
                        }
                        case 4: {
                            return this.lastRefreshFinishTimestamp;
                        }
                        case 9: {
                            return this.lastPeriodHi;
                        }
                        case 10: {
                            return this.lastRefreshTxn;
                        }
                        case 11: {
                            return this.lastAppliedBaseTxn;
                        }
                        case 15: {
                            return this.timerStart;
                        }
                    }
                    return 0L;
                }

                @Override
                public CharSequence getStrA(int col) {
                    switch (col) {
                        case 0: {
                            return this.viewDefinition.getMatViewToken().getTableName();
                        }
                        case 1: {
                            switch (this.viewDefinition.getRefreshType()) {
                                case 0: {
                                    return "immediate";
                                }
                                case 1: {
                                    return "timer";
                                }
                                case 2: {
                                    return "manual";
                                }
                            }
                            return "unknown";
                        }
                        case 2: {
                            return this.viewDefinition.getBaseTableName();
                        }
                        case 5: {
                            return this.viewDefinition.getMatViewSql();
                        }
                        case 6: {
                            return this.viewDefinition.getMatViewToken().getDirName();
                        }
                        case 8: {
                            return this.getViewStatus();
                        }
                        case 7: {
                            return this.invalidationReason.length() > 0 ? this.invalidationReason : null;
                        }
                        case 13: {
                            if (this.refreshLimitHoursOrMonths == 0) {
                                return null;
                            }
                            return TablesFunctionFactory.getTtlUnit(this.refreshLimitHoursOrMonths);
                        }
                        case 17: {
                            return MatViewsFunctionFactory.getIntervalUnit(this.timerIntervalUnit);
                        }
                        case 14: {
                            return this.viewDefinition.getTimerTimeZone();
                        }
                        case 19: {
                            return MatViewsFunctionFactory.getIntervalUnit(this.periodLengthUnit);
                        }
                        case 21: {
                            return MatViewsFunctionFactory.getIntervalUnit(this.periodDelayUnit);
                        }
                    }
                    return null;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStrA(col);
                }

                @Override
                public int getStrLen(int col) {
                    return TableUtils.lengthOf(this.getStrA(col));
                }

                public void of(MatViewDefinition viewDefinition, long lastRefreshStartTimestamp, long lastRefreshFinishTimestamp, long lastPeriodHi, long lastRefreshTxn, long lastAppliedBaseTxn, CharSequence invalidationReason, boolean invalid, int refreshLimitHoursOrMonths, long timerStart, int timerInterval, char timerIntervalUnit, int periodLength, char periodLengthUnit, int periodDelay, char periodDelayUnit) {
                    this.viewDefinition = viewDefinition;
                    this.lastRefreshStartTimestamp = lastRefreshStartTimestamp;
                    this.lastRefreshFinishTimestamp = lastRefreshFinishTimestamp;
                    this.lastPeriodHi = lastPeriodHi;
                    this.lastRefreshTxn = lastRefreshTxn;
                    this.lastAppliedBaseTxn = lastAppliedBaseTxn;
                    this.invalidationReason.clear();
                    this.invalidationReason.put(invalidationReason);
                    this.invalid = invalid;
                    this.refreshLimitHoursOrMonths = refreshLimitHoursOrMonths;
                    this.timerStart = timerStart;
                    this.timerInterval = timerInterval;
                    this.timerIntervalUnit = timerIntervalUnit;
                    this.periodLength = periodLength;
                    this.periodLengthUnit = periodLengthUnit;
                    this.periodDelay = periodDelay;
                    this.periodDelayUnit = periodDelayUnit;
                }

                private CharSequence getViewStatus() {
                    if (this.invalid) {
                        return "invalid";
                    }
                    return this.lastRefreshStartTimestamp != Long.MIN_VALUE && this.lastRefreshStartTimestamp > this.lastRefreshFinishTimestamp ? "refreshing" : "valid";
                }
            }
        }
    }
}

