/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToGeoHashFunction;
import io.questdb.griffin.engine.functions.cast.CastStrToGeoHashFunctionFactory;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;

public class CastVarcharToGeoHashFunctionFactory
implements FunctionFactory {
    public static Function newInstance(int argPosition, int geoType, Function value) throws SqlException {
        if (value.isConstant()) {
            int bits = ColumnType.getGeoHashBits(geoType);
            assert (bits > 0 && bits < 61);
            return Constants.getGeoHashConstantWithType(CastVarcharToGeoHashFunctionFactory.parseGeoHash(value.getVarcharA(null), argPosition, bits), geoType);
        }
        return new Func(geoType, value, argPosition);
    }

    @Override
    public String getSignature() {
        return "cast(\u00d8g)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        int argPosition = argPositions.getQuick(0);
        int geoType = args.getQuick(1).getType();
        if (value.isConstant()) {
            int bits = ColumnType.getGeoHashBits(geoType);
            assert (bits > 0 && bits < 61);
            return Constants.getGeoHashConstantWithType(CastVarcharToGeoHashFunctionFactory.parseGeoHash(value.getVarcharA(null), argPosition, bits), geoType);
        }
        return new Func(geoType, value, argPosition);
    }

    private static long parseGeoHash(Utf8Sequence value, int position, int typeBits) throws SqlException {
        if (value == null || value.size() == 0) {
            return -1L;
        }
        return CastStrToGeoHashFunctionFactory.parseGeoHash(value.asAsciiCharSequence(), position, typeBits);
    }

    private static class Func
    extends AbstractCastToGeoHashFunction {
        public Func(int geoType, Function arg, int position) {
            super(geoType, arg, position);
        }

        @Override
        protected long getGeoHashLong0(Record rec) {
            try {
                return CastVarcharToGeoHashFunctionFactory.parseGeoHash(this.arg.getVarcharA(rec), this.position, this.bitsPrecision);
            }
            catch (SqlException e) {
                return -1L;
            }
        }
    }
}

