/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.bool.WithinGeohashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import java.util.Objects;

public class CastGeoHashToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Gs)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function geoHashFunc = args.getQuick(0);
        if (geoHashFunc.isConstant()) {
            int geoHashFuncType = geoHashFunc.getType();
            StringSink sink = Misc.getThreadLocalSink();
            long hash = WithinGeohashFunctionFactory.getGeoHashAsLong(null, geoHashFunc, geoHashFuncType);
            GeoHashes.appendNoQuotes(hash, GeoHashes.getBitFlags(geoHashFuncType), sink);
            return new StrConstant(Chars.toString(sink));
        }
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToStrFunction {
        private final int argType;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public Func(Function arg) {
            super(arg);
            this.argType = arg.getType();
        }

        public void getStr(Record rec, StringSink sink) {
            long hash = WithinGeohashFunctionFactory.getGeoHashAsLong(rec, this.arg, this.argType);
            sink.clear();
            if (hash != -1L) {
                GeoHashes.appendNoQuotes(hash, GeoHashes.getBitFlags(this.argType), sink);
            }
        }

        @Override
        public CharSequence getStrA(Record rec) {
            this.getStr(rec, this.sinkA);
            return this.sinkA;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            this.getStr(rec, this.sinkB);
            return this.sinkB;
        }

        @Override
        public int getStrLen(Record rec) {
            return Objects.requireNonNull(this.getStrA(rec)).length();
        }
    }
}

