/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToLong256Function;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;

public class CastFloatToLong256FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Fh)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToLong256Function {
        private final Long256Impl long256a = new Long256Impl();
        private final Long256Impl long256b = new Long256Impl();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public void getLong256(Record rec, CharSink<?> sink) {
            float value = this.arg.getFloat(rec);
            if (Numbers.isNull(value)) {
                return;
            }
            Numbers.appendLong256((long)value, 0L, 0L, 0L, sink);
        }

        @Override
        public Long256 getLong256A(Record rec) {
            float value = this.arg.getFloat(rec);
            if (Numbers.isNull(value)) {
                return Long256Impl.NULL_LONG256;
            }
            this.long256a.setLow((long)value);
            return this.long256a;
        }

        @Override
        public Long256 getLong256B(Record rec) {
            float value = this.arg.getFloat(rec);
            if (Numbers.isNull(value)) {
                return Long256Impl.NULL_LONG256;
            }
            this.long256b.setLow((long)value);
            return this.long256b;
        }
    }
}

