/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToDateFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class CastFloatToDateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Fm)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToDateFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public long getDate(Record rec) {
            float value = this.arg.getFloat(rec);
            return Numbers.isNull(value) || value > 9.223372E18f || value < -9.223372E18f ? Long.MIN_VALUE : (long)value;
        }
    }
}

