/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToIntFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class CastDoubleToIntFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Di)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToIntFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            double value = this.arg.getDouble(rec);
            return Numbers.isNull(value) || value > 2.147483647E9 || value < -2.147483648E9 ? Integer.MIN_VALUE : (int)value;
        }
    }
}

