/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.NoopArrayWriteState;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToVarcharFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import org.jetbrains.annotations.Nullable;

public class CastDoubleArrayToVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(D[]\u00f8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToVarcharFunction {
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharA(Record rec) {
            return this.toSinkOrNull(this.sinkA, rec);
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharB(Record rec) {
            return this.toSinkOrNull(this.sinkB, rec);
        }

        private Utf8StringSink toSinkOrNull(Utf8StringSink sink, Record rec) {
            ArrayView arrayView = this.arg.getArray(rec);
            if (arrayView.isNull()) {
                return null;
            }
            sink.clear();
            ArrayTypeDriver.arrayToJson(arrayView, sink, NoopArrayWriteState.INSTANCE);
            return sink;
        }
    }
}

