/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DerivedArrayView;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public final class CastDoubleArrayToDoubleArrayFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(D[]d[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function fromFunc = args.getQuick(0);
        int fromType = fromFunc.getType();
        int toType = args.getQuick(1).getType();
        int dimsToAdd = ColumnType.decodeArrayDimensionality(toType) - ColumnType.decodeArrayDimensionality(fromType);
        if (dimsToAdd < 0) {
            throw SqlException.$(position, "cannot cast array to lower dimension [from=").put(ColumnType.nameOf(fromType)).put(" (").put(ColumnType.decodeArrayDimensionality(fromType)).put("D)").put(", to=").put(ColumnType.nameOf(toType)).put(" (").put(ColumnType.decodeArrayDimensionality(toType)).put("D)").put("]. Use array flattening operation (e.g. 'flatten(arr)') instead");
        }
        if (dimsToAdd == 0) {
            return fromFunc;
        }
        return new Func(fromFunc, toType, dimsToAdd);
    }

    public static final class Func
    extends ArrayFunction
    implements UnaryFunction {
        private final Function arg;
        private final DerivedArrayView derivedArray = new DerivedArrayView();
        private final int dimsToAdd;

        public Func(Function arg, int toType, int dimsToAdd) {
            this.type = toType;
            int fromType = arg.getType();
            assert (ColumnType.isArray(fromType));
            assert (ColumnType.isArray(toType));
            assert (ColumnType.decodeArrayElementType(fromType) == ColumnType.decodeArrayElementType(toType));
            assert (dimsToAdd > 0);
            this.arg = arg;
            this.dimsToAdd = dimsToAdd;
        }

        @Override
        public void close() {
            UnaryFunction.super.close();
            Misc.free(this.derivedArray);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView array = this.arg.getArray(rec);
            this.derivedArray.of(array);
            this.derivedArray.prependDimensions(this.dimsToAdd);
            return this.derivedArray;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }
    }
}

