/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Utf8SequenceHashSet;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;

public class InVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(\u00d8v)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int n = args.size();
        if (n == 1) {
            return BooleanConstant.FALSE;
        }
        boolean allConst = true;
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 0: 
                case 4: 
                case 11: 
                case 12: 
                case 26: 
                case 33: {
                    break;
                }
                default: {
                    throw SqlException.position(argPositions.getQuick(i)).put("cannot compare VARCHAR with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
            if (func.isConstant()) continue;
            allConst = false;
            if (func.isRuntimeConstant()) continue;
            throw SqlException.position(argPositions.getQuick(i)).put("unsupported expression");
        }
        if (allConst) {
            Utf8SequenceHashSet set = new Utf8SequenceHashSet();
            InVarcharFunctionFactory.parseToVarchar(args, argPositions, set);
            Function arg = args.getQuick(0);
            if (arg.isConstant()) {
                return BooleanConstant.of(set.contains(arg.getVarcharA(null)));
            }
            return new ConstFunc(arg, set);
        }
        IntList positions = new IntList();
        positions.addAll(argPositions);
        return new RuntimeConstFunc(new ObjList<Function>(args), positions);
    }

    private static void parseToVarchar(ObjList<Function> args, IntList argPositions, Utf8SequenceHashSet set) throws SqlException {
        set.clear();
        int n = args.size();
        block4: for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 11: 
                case 12: 
                case 26: 
                case 33: {
                    set.add(Utf8s.toUtf8String(func.getVarcharA(null)));
                    continue block4;
                }
                case 4: {
                    set.add(new Utf8String(func.getChar(null)));
                    continue block4;
                }
                default: {
                    throw SqlException.position(argPositions.getQuick(i)).put("cannot compare VARCHAR with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
        }
    }

    private static class ConstFunc
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final Utf8SequenceHashSet set;

        public ConstFunc(Function arg, Utf8SequenceHashSet set) {
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence val = this.arg.getVarcharA(rec);
            return this.set.contains(val);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val(" in ").val(this.set);
        }
    }

    private static class RuntimeConstFunc
    extends BooleanFunction
    implements MultiArgFunction {
        private final IntList argPositions;
        private final ObjList<Function> args;
        private final Utf8SequenceHashSet set = new Utf8SequenceHashSet();

        public RuntimeConstFunc(ObjList<Function> args, IntList argPositions) {
            this.args = args;
            this.argPositions = argPositions;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence val = this.args.getQuick(0).getVarcharA(rec);
            return this.set.contains(val);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            MultiArgFunction.super.init(symbolTableSource, executionContext);
            InVarcharFunctionFactory.parseToVarchar(this.args, this.argPositions, this.set);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.args.getQuick(0)).val(" in ").val(this.args, 1);
        }
    }
}

