/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class InStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(Sv)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int n = args.size();
        if (n == 1) {
            return BooleanConstant.FALSE;
        }
        boolean allConst = true;
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 0: 
                case 4: 
                case 11: 
                case 12: 
                case 26: 
                case 33: {
                    break;
                }
                default: {
                    throw SqlException.position(argPositions.getQuick(i)).put("cannot compare STRING with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
            if (func.isConstant()) continue;
            allConst = false;
            if (func.isRuntimeConstant()) continue;
            throw SqlException.position(argPositions.getQuick(i)).put("unsupported expression");
        }
        if (allConst) {
            CharSequenceHashSet set = new CharSequenceHashSet();
            InStrFunctionFactory.parseToString(args, argPositions, set);
            Function arg = args.getQuick(0);
            if (arg.isConstant()) {
                return BooleanConstant.of(set.contains(arg.getStrA(null)));
            }
            return new ConstFunc(arg, set);
        }
        IntList positions = new IntList();
        positions.addAll(argPositions);
        return new RuntimeConstFunc(new ObjList<Function>(args), positions);
    }

    private static void parseToString(ObjList<Function> args, IntList argPositions, CharSequenceHashSet set) throws SqlException {
        set.clear();
        int n = args.size();
        block4: for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 11: 
                case 12: 
                case 26: 
                case 33: {
                    set.add(Chars.toString(func.getStrA(null)));
                    continue block4;
                }
                case 4: {
                    set.add(String.valueOf(func.getChar(null)));
                    continue block4;
                }
                default: {
                    throw SqlException.position(argPositions.getQuick(i)).put("cannot compare STRING with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
        }
    }

    private static class ConstFunc
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final CharSequenceHashSet set;

        public ConstFunc(Function arg, CharSequenceHashSet set) {
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence val = this.arg.getStrA(rec);
            return this.set.contains(val);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val(" in ").val(this.set);
        }
    }

    private static class RuntimeConstFunc
    extends BooleanFunction
    implements MultiArgFunction {
        private final IntList argPositions;
        private final ObjList<Function> args;
        private final CharSequenceHashSet set = new CharSequenceHashSet();

        public RuntimeConstFunc(ObjList<Function> args, IntList argPositions) {
            this.args = args;
            this.argPositions = argPositions;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence val = this.args.getQuick(0).getStrA(rec);
            return this.set.contains(val);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            MultiArgFunction.super.init(symbolTableSource, executionContext);
            InStrFunctionFactory.parseToString(this.args, this.argPositions, this.set);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.args.getQuick(0)).val(" in ").val(this.args, 1);
        }
    }
}

