/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class Base64FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "base64(Ui)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int maxLength = args.get(1).getInt(null);
        if (maxLength < 1) {
            throw SqlException.$(argPositions.getQuick(1), "maxLength has to be greater than 0");
        }
        Function func = args.get(0);
        int length = Math.min(maxLength, configuration.getBinaryEncodingMaxLength());
        return new Base64Func(func, length);
    }

    private static class Base64Func
    extends StrFunction
    implements UnaryFunction {
        private final Function data;
        private final int maxLength;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public Base64Func(Function data, int maxLength) {
            this.data = data;
            this.maxLength = maxLength;
        }

        @Override
        public Function getArg() {
            return this.data;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            BinarySequence sequence = this.getArg().getBin(rec);
            if (sequence == null) {
                return null;
            }
            this.sinkA.clear();
            Chars.base64Encode(sequence, this.maxLength, this.sinkA);
            return this.sinkA;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            BinarySequence sequence = this.getArg().getBin(rec);
            if (sequence == null) {
                return null;
            }
            this.sinkB.clear();
            Chars.base64Encode(sequence, this.maxLength, this.sinkB);
            return this.sinkB;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("base64(").val(this.data).val(',').val(this.maxLength).val(')');
        }
    }
}

