/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.cutlass.text.types.TimestampCompatibleAdapter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.DirectUtf8Sequence;

public final class LongAdapter
extends AbstractTypeAdapter
implements TimestampCompatibleAdapter {
    public static final LongAdapter INSTANCE = new LongAdapter();

    private LongAdapter() {
    }

    public long getLong(DirectUtf8Sequence value) throws Exception {
        return Numbers.parseLong(value);
    }

    @Override
    public long getTimestamp(DirectUtf8Sequence value) throws Exception {
        return this.getLong(value);
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public boolean probe(DirectUtf8Sequence text) {
        if (text.size() > 2 && text.byteAt(0) == 48 && text.byteAt(1) != 46) {
            return false;
        }
        try {
            Numbers.parseLong(text);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value) throws Exception {
        row.putLong(column, SqlKeywords.isNullKeyword(value) ? Long.MIN_VALUE : this.getLong(value));
    }
}

