/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.cutlass.text.ParallelCsvFileImporter;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextImportException;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8String;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SerialCsvFileImporter
implements Closeable {
    private static final Log LOG = LogFactory.getLog(SerialCsvFileImporter.class);
    private final CairoEngine cairoEngine;
    private final CairoConfiguration configuration;
    private final FilesFacade ff;
    private final CharSequence inputRoot;
    private int atomicity;
    private ExecutionCircuitBreaker circuitBreaker;
    private byte columnDelimiter;
    private boolean forceHeader;
    private long importId;
    private Path inputFilePath;
    private ParallelCsvFileImporter.PhaseStatusReporter statusReporter;
    private String tableName;
    private TextLoader textLoader;
    private CharSequence timestampColumn;
    private CharSequence timestampFormat;

    public SerialCsvFileImporter(CairoEngine cairoEngine) {
        try {
            this.configuration = cairoEngine.getConfiguration();
            this.inputRoot = this.configuration.getSqlCopyInputRoot();
            this.inputFilePath = new Path();
            this.ff = this.configuration.getFilesFacade();
            this.textLoader = new TextLoader(cairoEngine);
            this.cairoEngine = cairoEngine;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void close() {
        this.inputFilePath = Misc.free(this.inputFilePath);
        this.textLoader = Misc.free(this.textLoader);
    }

    public void of(@NotNull String tableName, @NotNull String inputFileName, long importId, byte columnDelimiter, @Nullable String timestampColumn, @Nullable String timestampFormat, boolean forceHeader, @NotNull ExecutionCircuitBreaker circuitBreaker, int atomicity) {
        this.tableName = tableName;
        this.timestampColumn = timestampColumn;
        this.timestampFormat = timestampFormat;
        this.columnDelimiter = columnDelimiter;
        this.forceHeader = forceHeader;
        this.circuitBreaker = circuitBreaker;
        this.atomicity = atomicity;
        this.importId = importId;
        this.inputFilePath.of(this.inputRoot).concat(inputFileName);
    }

    public void process(SecurityContext securityContext) throws TextImportException {
        LOG.info().$("started [importId=").$hexPadded(this.importId).$(", file=`").$(this.inputFilePath).$('`').I$();
        long startMs = this.getCurrentTimeMs();
        this.updateImportStatus((byte)0, Long.MIN_VALUE, Long.MIN_VALUE, 0L);
        this.setupTextLoaderFromModel();
        int sqlCopyBufferSize = this.cairoEngine.getConfiguration().getSqlCopyBufferSize();
        long buf = Unsafe.malloc(sqlCopyBufferSize, 35);
        long fd = -1L;
        try {
            fd = TableUtils.openRO(this.ff, this.inputFilePath.$(), LOG);
            long fileLen = this.ff.length(fd);
            long n = this.ff.read(fd, buf, sqlCopyBufferSize, 0L);
            if (n > 0L) {
                if (this.columnDelimiter > 0) {
                    this.textLoader.configureColumnDelimiter(this.columnDelimiter);
                }
                this.textLoader.setForceHeaders(this.forceHeader);
                this.textLoader.setSkipLinesWithExtraValues(false);
                this.textLoader.parse(buf, buf + n, securityContext);
                this.textLoader.setState(2);
                while (n < fileLen) {
                    if (this.circuitBreaker.checkIfTripped()) {
                        TextImportException ex = TextImportException.instance((byte)-1, "import was cancelled");
                        ex.setCancelled(true);
                        throw ex;
                    }
                    int read = (int)this.ff.read(fd, buf, sqlCopyBufferSize, n);
                    if (read < 1) {
                        throw TextImportException.instance((byte)-1, "could not read file [errno=").put(this.ff.errno()).put(']');
                    }
                    this.textLoader.parse(buf, buf + (long)read, securityContext);
                    n += (long)read;
                }
                this.textLoader.wrapUp();
                long errorCount = this.textLoader.getErrorLineCount();
                LongList columnErrorCounts = this.textLoader.getColumnErrorCounts();
                int size = columnErrorCounts.size();
                for (int i = 0; i < size; ++i) {
                    errorCount += columnErrorCounts.get(i);
                }
                this.updateImportStatus((byte)1, this.textLoader.getParsedLineCount(), this.textLoader.getWrittenLineCount(), errorCount);
                long endMs = this.getCurrentTimeMs();
                LOG.info().$("import complete [importId=").$hexPadded(this.importId).$(", file=`").$(this.inputFilePath).$('`').$("', time=").$((endMs - startMs) / 1000L).$('s').I$();
            }
        }
        catch (TextException e) {
            throw TextImportException.instance((byte)-1, e.getFlyweightMessage());
        }
        catch (CairoException e) {
            throw TextImportException.instance((byte)-1, e.getFlyweightMessage(), e.getErrno());
        }
        finally {
            this.ff.close(fd);
            this.textLoader.clear();
            Unsafe.free(buf, sqlCopyBufferSize, 35);
        }
    }

    public void setStatusReporter(ParallelCsvFileImporter.PhaseStatusReporter reporter) {
        this.statusReporter = reporter;
    }

    public void updateImportStatus(byte status, long rowsHandled, long rowsImported, long errors) {
        if (this.statusReporter != null) {
            this.statusReporter.report((byte)-1, status, null, rowsHandled, rowsImported, errors);
        }
    }

    private long getCurrentTimeMs() {
        return this.configuration.getMillisecondClock().getTicks();
    }

    private void setupTextLoaderFromModel() {
        this.textLoader.clear();
        this.textLoader.setState(1);
        this.textLoader.configureDestination(new Utf8String(this.tableName), false, this.atomicity != -1 ? this.atomicity : 1, 3, this.timestampColumn != null ? new Utf8String(this.timestampColumn) : null, this.timestampFormat != null ? new Utf8String(this.timestampFormat) : null);
    }
}

