/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoError;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.types.InputFormatConfiguration;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.DateLocaleFactory;
import io.questdb.std.datetime.microtime.TimestampFormatFactory;
import io.questdb.std.datetime.millitime.DateFormatFactory;
import io.questdb.std.datetime.millitime.DateFormatUtils;

public class DefaultTextConfiguration
implements TextConfiguration {
    private final InputFormatConfiguration inputFormatConfiguration = new InputFormatConfiguration(new DateFormatFactory(), DateLocaleFactory.INSTANCE, new TimestampFormatFactory(), DateFormatUtils.EN_LOCALE);

    public DefaultTextConfiguration() {
        this(null);
    }

    public DefaultTextConfiguration(String confRoot) {
        this(DefaultTextConfiguration.class, confRoot, "/text_loader.json");
    }

    public DefaultTextConfiguration(Class<?> resourceLoader, String confRoot, String resourceName) {
        try (JsonLexer lexer = new JsonLexer(1024, 1024);){
            this.inputFormatConfiguration.parseConfiguration(resourceLoader, lexer, confRoot, resourceName);
        }
        catch (JsonException e) {
            throw new CairoError(e);
        }
    }

    @Override
    public int getDateAdapterPoolCapacity() {
        return 16;
    }

    @Override
    public DateLocale getDefaultDateLocale() {
        return DateFormatUtils.EN_LOCALE;
    }

    @Override
    public InputFormatConfiguration getInputFormatConfiguration() {
        return this.inputFormatConfiguration;
    }

    @Override
    public int getJsonCacheLimit() {
        return 16384;
    }

    @Override
    public int getJsonCacheSize() {
        return 8192;
    }

    @Override
    public double getMaxRequiredDelimiterStdDev() {
        return 0.35;
    }

    @Override
    public double getMaxRequiredLineLengthStdDev() {
        return 0.8;
    }

    @Override
    public int getMetadataStringPoolCapacity() {
        return 128;
    }

    @Override
    public int getRollBufferLimit() {
        return 16384;
    }

    @Override
    public int getRollBufferSize() {
        return 4096;
    }

    @Override
    public int getTextAnalysisMaxLines() {
        return 1000;
    }

    @Override
    public int getTextLexerStringPoolCapacity() {
        return 32;
    }

    @Override
    public int getTimestampAdapterPoolCapacity() {
        return 16;
    }

    @Override
    public int getUtf8SinkSize() {
        return 4096;
    }

    @Override
    public boolean isUseLegacyStringDefault() {
        return false;
    }
}

