/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cutlass.auth.AuthUtils;
import io.questdb.cutlass.auth.ChallengeResponseMatcher;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectUtf8String;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;

public class StaticChallengeResponseMatcher
implements ChallengeResponseMatcher {
    private static final Log LOG = LogFactory.getLog(StaticChallengeResponseMatcher.class);
    private final byte[] challengeBytes = new byte[512];
    private final CharSequenceObjHashMap<PublicKey> publicKeyByKeyId;
    private final ByteBuffer signatureBuffer = ByteBuffer.allocate(72);
    private final DirectUtf8String signatureFlyweight = new DirectUtf8String();

    public StaticChallengeResponseMatcher(CharSequenceObjHashMap<PublicKey> authDb) {
        this.publicKeyByKeyId = authDb;
    }

    @Override
    public boolean verifyJwk(CharSequence username, long challengePtr, int challengeLen, long signaturePtr, int signatureLen) {
        assert (challengeLen == 512);
        PublicKey publicKey = this.getPublicKey(username);
        if (publicKey == null) {
            LOG.info().$("authentication failed, unknown key [id=").$(username).$(']').$();
            return false;
        }
        this.signatureBuffer.clear();
        this.signatureFlyweight.of(signaturePtr, signaturePtr + (long)signatureLen);
        Chars.base64Decode(this.signatureFlyweight.asAsciiCharSequence(), this.signatureBuffer);
        this.signatureBuffer.flip();
        for (int i = 0; i < challengeLen; ++i) {
            this.challengeBytes[i] = Unsafe.getUnsafe().getByte(challengePtr + (long)i);
        }
        try {
            return AuthUtils.isSignatureMatch(publicKey, this.challengeBytes, this.signatureBuffer);
        }
        catch (InvalidKeyException | SignatureException ex) {
            LOG.info().$(" authentication exception ").$(ex).$();
            return false;
        }
    }

    private PublicKey getPublicKey(CharSequence keyId) {
        return this.publicKeyByKeyId.get(keyId);
    }
}

