/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.json;

import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.json.JsonParser;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjectPool;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.DirectUtf8Sink;

public abstract class AbstractJsonParser
implements JsonParser,
Mutable,
QuietCloseable {
    private final ObjectPool<FloatingCharSequence> csPool;
    private final JsonLexer lexer;
    private long buf;
    private long bufCapacity = 0L;
    private int bufSize = 0;

    protected AbstractJsonParser(int initialStringPoolCapacity) {
        this(0, 0, initialStringPoolCapacity);
    }

    protected AbstractJsonParser(int initialCacheSize, int cacheSizeLimit, int initialStringPoolCapacity) {
        this.csPool = new ObjectPool<FloatingCharSequence>(() -> new FloatingCharSequence(), initialStringPoolCapacity);
        this.lexer = new JsonLexer(initialCacheSize, cacheSizeLimit);
    }

    @Override
    public void clear() {
        this.lexer.clear();
        this.csPool.clear();
    }

    @Override
    public void close() {
        this.clear();
        Misc.free(this.lexer);
        if (this.bufCapacity > 0L) {
            Unsafe.free(this.buf, this.bufCapacity, 57);
            this.bufCapacity = 0L;
        }
    }

    public void parse(DirectUtf8Sink utf8Sink) throws JsonException {
        this.parse(utf8Sink.lo(), utf8Sink.hi());
    }

    public void parse(long lo, long hi) throws JsonException {
        this.lexer.parse(lo, hi, this);
    }

    private static void strcpyw(CharSequence value, int len, long address) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putChar(address + ((long)i << 1), value.charAt(i));
        }
    }

    protected CharSequence copy(CharSequence tag) {
        int l = tag.length() * 2;
        long n = this.bufSize + l;
        if (n > this.bufCapacity) {
            long ptr = Unsafe.malloc(n * 2L, 57);
            Vect.memcpy(ptr, this.buf, this.bufSize);
            if (this.bufCapacity > 0L) {
                Unsafe.free(this.buf, this.bufCapacity, 57);
            }
            this.buf = ptr;
            this.bufCapacity = n * 2L;
        }
        AbstractJsonParser.strcpyw(tag, l / 2, this.buf + (long)this.bufSize);
        CharSequence cs = this.csPool.next().of(this.bufSize, l / 2);
        this.bufSize += l;
        return cs;
    }

    private class FloatingCharSequence
    extends AbstractCharSequence
    implements Mutable {
        private int len;
        private int offset;

        private FloatingCharSequence() {
        }

        @Override
        public char charAt(int index) {
            return Unsafe.getUnsafe().getChar(AbstractJsonParser.this.buf + (long)this.offset + (long)index * 2L);
        }

        @Override
        public void clear() {
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        protected final CharSequence _subSequence(int start, int end) {
            FloatingCharSequence that = AbstractJsonParser.this.csPool.next();
            that.of(this.offset + 2 * start, end - start);
            return that;
        }

        CharSequence of(int lo, int len) {
            this.offset = lo;
            this.len = len;
            return this;
        }
    }
}

