/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.client;

import io.questdb.ClientTlsConfiguration;
import io.questdb.DefaultHttpClientConfiguration;
import io.questdb.HttpClientConfiguration;
import io.questdb.cutlass.http.client.HttpClient;
import io.questdb.cutlass.http.client.HttpClientLinux;
import io.questdb.cutlass.http.client.HttpClientOsx;
import io.questdb.cutlass.http.client.HttpClientWindows;
import io.questdb.network.JavaTlsClientSocketFactory;
import io.questdb.network.PlainSocketFactory;
import io.questdb.network.SocketFactory;
import io.questdb.std.Os;

public class HttpClientFactory {
    public static HttpClient newInsecureTlsInstance() {
        return HttpClientFactory.newInstance(DefaultHttpClientConfiguration.INSTANCE, JavaTlsClientSocketFactory.INSECURE_NO_VALIDATION);
    }

    public static HttpClient newInstance(HttpClientConfiguration configuration, SocketFactory socketFactory) {
        switch (Os.type) {
            case 2: {
                return new HttpClientLinux(configuration, socketFactory);
            }
            case 1: 
            case 4: {
                return new HttpClientOsx(configuration, socketFactory);
            }
            case 3: {
                return new HttpClientWindows(configuration, socketFactory);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static HttpClient newPlainTextInstance() {
        return HttpClientFactory.newPlainTextInstance(DefaultHttpClientConfiguration.INSTANCE);
    }

    public static HttpClient newPlainTextInstance(HttpClientConfiguration configuration) {
        return HttpClientFactory.newInstance(configuration, PlainSocketFactory.INSTANCE);
    }

    public static HttpClient newTlsInstance(HttpClientConfiguration configuration, ClientTlsConfiguration tlsConfig) {
        return HttpClientFactory.newInstance(configuration, new JavaTlsClientSocketFactory(tlsConfig));
    }
}

