/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.Metrics;
import io.questdb.cairo.SecurityContext;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpException;
import io.questdb.metrics.AtomicLongGauge;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.QueryPausedException;
import io.questdb.network.ServerDisconnectException;

public interface HttpRequestProcessor {
    default public AtomicLongGauge connectionCountGauge(Metrics metrics) {
        return metrics.jsonQueryMetrics().connectionCountGauge();
    }

    default public void failRequest(HttpConnectionContext context, HttpException exception) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
    }

    default public int getConnectionLimit(HttpContextConfiguration configuration) {
        return configuration.getJsonQueryConnectionLimit();
    }

    default public byte getRequiredAuthType() {
        return 1;
    }

    default public boolean ignoreConnectionLimitCheck() {
        return false;
    }

    default public short getSupportedRequestTypes() {
        return 1;
    }

    default public void onConnectionClosed(HttpConnectionContext context) {
    }

    default public void onHeadersReady(HttpConnectionContext context) {
    }

    default public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
    }

    default public void onRequestRetry(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
    }

    default public void parkRequest(HttpConnectionContext context, boolean pausedQuery) {
    }

    default public boolean processCookies(HttpConnectionContext context, SecurityContext securityContext) throws PeerIsSlowToReadException, PeerDisconnectedException {
        return true;
    }

    default public boolean requiresAuthentication() {
        return this.getRequiredAuthType() != 0;
    }

    default public void resumeRecv(HttpConnectionContext context) {
    }

    default public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
    }
}

